/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.beans.model.ConversionService;
import org.aksw.commons.beans.model.ConversionServiceAdapter;
import org.aksw.commons.beans.model.EntityModel;
import org.aksw.commons.beans.model.EntityOps;
import org.aksw.commons.beans.model.PropertyOps;
import org.aksw.commons.collections.frontier.Frontier;
import org.aksw.commons.collections.frontier.FrontierImpl;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.concept.parser.SparqlRelationParser;
import org.aksw.jena_sparql_api.concept.parser.SparqlRelationParserImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfClass;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfPropertyDescriptor;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeBase;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeIriStr;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeLiteralTyped;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeMap;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeNode;
import org.aksw.jena_sparql_api.mapper.model.F_GetValue;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperPropertyBase;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperPropertyMulti;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperPropertySingle;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.mapper.model.TypeConversionService;
import org.aksw.jena_sparql_api.mapper.model.TypeConversionServiceImpl;
import org.aksw.jena_sparql_api.mapper.model.TypeConverter;
import org.aksw.jenax.annotation.reprogen.Datatype;
import org.aksw.jenax.annotation.reprogen.DefaultIri;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.IriType;
import org.aksw.jenax.annotation.reprogen.MappedBy;
import org.aksw.jenax.annotation.reprogen.MultiValued;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.util.SplitIRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class RdfTypeFactoryImpl
implements RdfTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(RdfTypeFactoryImpl.class);
    protected ExpressionParser parser;
    protected EvaluationContext evalContext;
    protected ParserContext parserContext;
    protected Prologue prologue;
    protected SparqlRelationParser relationParser;
    protected Function<Class<?>, EntityOps> entityOpsFactory;
    protected Map<Class<?>, RdfType> classToRdfType = new HashMap();
    protected TypeMapper typeMapper;
    protected ConversionService conversionService;
    protected TypeConversionService typeConversionService = new TypeConversionServiceImpl();

    public RdfTypeFactoryImpl(ExpressionParser parser, ParserContext parserContext, EvaluationContext evalContext, TypeMapper typeMapper, Prologue prologue, SparqlRelationParser relationParser, Function<Class<?>, EntityOps> entityOpsFactory, ConversionService conversionService) {
        this.parser = parser;
        this.evalContext = evalContext;
        this.parserContext = parserContext;
        this.typeMapper = typeMapper;
        this.prologue = prologue;
        this.relationParser = relationParser;
        this.entityOpsFactory = entityOpsFactory;
        this.conversionService = conversionService;
    }

    public Function<Class<?>, EntityOps> getEntityOpsFactory() {
        return this.entityOpsFactory;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    public Map<Class<?>, RdfType> getClassToRdfType() {
        return this.classToRdfType;
    }

    public TypeConversionService getTypeConversionService() {
        return this.typeConversionService;
    }

    @Override
    public RdfType forJavaType(Class<?> clazz) {
        RdfType result = this.getOrAllocateRdfType(clazz);
        if (result instanceof RdfClass) {
            RdfClass tmp = (RdfClass)result;
            this.populateClasses(tmp);
        }
        return result;
    }

    protected RdfType getOrAllocateRdfType(Class<?> clazz) {
        RdfType result = this.classToRdfType.get(clazz);
        if (result == null) {
            result = this.allocateRdfType(clazz);
            this.classToRdfType.put(clazz, result);
        }
        return result;
    }

    protected RdfType allocateRdfType(Class<?> clazz) {
        RDFDatatype dtype = this.typeMapper.getTypeByClass(clazz);
        boolean isPrimitive = dtype != null;
        RdfTypeBase result = isPrimitive ? new RdfTypeLiteralTyped(this, dtype) : this.allocateRdfClass(clazz);
        return result;
    }

    protected RdfClass allocateRdfClass(Class<?> clazz) {
        EntityOps entityOps = this.entityOpsFactory.apply(clazz);
        RdfClass result = this.allocateRdfClass(entityOps);
        return result;
    }

    protected RdfClass allocateRdfClass(EntityOps entityOps) {
        org.aksw.jenax.annotation.reprogen.RdfType rdfType = (org.aksw.jenax.annotation.reprogen.RdfType)entityOps.findAnnotation(org.aksw.jenax.annotation.reprogen.RdfType.class);
        DefaultIri defaultIri = (DefaultIri)entityOps.findAnnotation(DefaultIri.class);
        Function<Object, String> defaultIriFn = null;
        if (defaultIri != null) {
            String iriStr = defaultIri.value();
            defaultIriFn = o -> this.resolveIriExpr(iriStr, o);
        }
        RdfClass result = new RdfClass(entityOps, defaultIriFn);
        return result;
    }

    protected String resolveIriExpr(String exprStr, Object rootObject) {
        Expression expression = this.parser.parseExpression(exprStr, this.parserContext);
        String tmp = (String)expression.getValue(this.evalContext, rootObject, String.class);
        tmp = tmp.trim();
        PrefixMapping prefixMapping = this.prologue.getPrefixMapping();
        String result = prefixMapping.expandPrefix(tmp);
        return result;
    }

    private void populateClasses(RdfClass rootRdfClass) {
        FrontierImpl frontier = FrontierImpl.createIdentityFrontier();
        frontier.add((Object)rootRdfClass);
        while (!frontier.isEmpty()) {
            RdfClass rdfClass = (RdfClass)frontier.next();
            this.initProperties(rdfClass, (Frontier<RdfClass>)frontier);
        }
    }

    private void initProperties(RdfClass rdfClass, Frontier<RdfClass> frontier) {
        if (!rdfClass.isPopulated()) {
            logger.debug("Initializing RdfClass for [" + rdfClass.getEntityOps().getAssociatedClass().getName() + "]");
            EntityOps entityOps = rdfClass.getEntityOps();
            for (PropertyOps pd : entityOps.getProperties()) {
                this.processProperty(rdfClass, entityOps, pd, frontier);
            }
        }
        rdfClass.setPopulated(true);
    }

    public String getIri(EntityOps entityOps, PropertyOps pd) {
        List iriNsStrs;
        Optional<IriNs> propertyIriNsOpt;
        String propertyName = pd.getName();
        Optional<Iri> iriOpt = Optional.ofNullable((Iri)pd.findAnnotation(Iri.class));
        List iris = iriOpt.map(Iri::value).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
        Preconditions.checkArgument((iris.size() <= 1 ? 1 : 0) != 0, (Object)"Currently @Iri is only supporting with a most one argument");
        String iriStr = iris.stream().map(iriExprStr -> this.resolveIriExpr((String)iriExprStr, null)).findFirst().orElse(null);
        Optional<IriNs> effectiveIriNsOpt = propertyIriNsOpt = Optional.ofNullable((IriNs)pd.findAnnotation(IriNs.class));
        if (iriOpt.isPresent() && Strings.isNullOrEmpty((String)iriStr)) {
            Optional<IriNs> classIriNs = Optional.ofNullable((IriNs)entityOps.findAnnotation(IriNs.class));
            effectiveIriNsOpt = classIriNs;
        }
        Preconditions.checkArgument(((iriNsStrs = effectiveIriNsOpt.map(IriNs::value).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList())).size() <= 1 ? 1 : 0) != 0, (Object)"Currently @IriNs is only supported with at most one argument");
        String iriNsStr = iriNsStrs.stream().map(iriNsExprStr -> iriNsExprStr + (iriNsExprStr.contains(":") ? "" : ":") + propertyName).map(iriNsExprStr -> this.resolveIriExpr((String)iriNsExprStr, null)).findFirst().orElse(null);
        if (iriNsStr != null) {
            if (!Strings.isNullOrEmpty((String)iriStr)) {
                throw new RuntimeException("@Iri and @IriNs annotations on same element is invalid");
            }
            iriStr = iriNsStr;
        }
        return iriStr;
    }

    protected void processProperty(RdfClass rdfClass, EntityOps entityOps, PropertyOps pd, Frontier<RdfClass> frontier) {
        boolean isMappedBy;
        Object result = null;
        Class clazz = entityOps.getAssociatedClass();
        String propertyName = pd.getName();
        boolean isReadable = pd.isReadable();
        boolean isWritable = pd.isWritable();
        boolean isCandidate = isReadable && isWritable;
        String iriStr = this.getIri(entityOps, pd);
        boolean hasIri = iriStr != null && !iriStr.isEmpty();
        String mappedBy = (String)AnnotationUtils.getValue((Annotation)((Annotation)pd.findAnnotation(MappedBy.class)));
        boolean bl = isMappedBy = mappedBy != null;
        if (isCandidate && (hasIri || isMappedBy)) {
            logger.debug("Annotation on property " + propertyName + " detected: " + iriStr);
            Property predicate = iriStr != null ? ResourceFactory.createProperty((String)iriStr) : null;
            this.processProperty(rdfClass, entityOps, pd, predicate, frontier);
        } else {
            logger.debug("Ignoring property " + propertyName);
        }
    }

    public static Class<?> extractItemType(Type genericType) {
        ParameterizedType pt;
        Type[] types;
        Class result = null;
        if (genericType instanceof ParameterizedType && (types = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            result = (Class)types[0];
        }
        return result;
    }

    protected void processProperty(RdfClass rdfClass, EntityOps beanInfo, PropertyOps pd, Property predicate, Frontier<RdfClass> frontier) {
        String rawDtName;
        String dtName;
        BiFunction<Object, Object, Node> defaultIriFn;
        RdfType targetRdfType;
        RDFDatatype dtype;
        boolean isMultiValued;
        Class entityClass = beanInfo.getAssociatedClass();
        String propertyName = pd.getName();
        Class<?> propertyType = pd.getType();
        boolean isCollectionProperty = Collection.class.isAssignableFrom(propertyType);
        boolean bl = isMultiValued = pd.findAnnotation(MultiValued.class) != null;
        if (isMultiValued && !isCollectionProperty) {
            throw new RuntimeException("Invalid annotation: " + String.valueOf(entityClass) + "." + pd.getName() + ":  is declared MultiValued however is not a Collection");
        }
        if (isCollectionProperty) {
            Type paramType = pd.getWriteMethod().getGenericParameterTypes()[0];
            propertyType = RdfTypeFactoryImpl.extractItemType(paramType);
        }
        boolean isLiteral = (dtype = this.typeMapper.getTypeByClass((Class)propertyType)) != null;
        IriType iriType = (IriType)pd.findAnnotation(IriType.class);
        if (iriType == null) {
            if (isLiteral) {
                targetRdfType = new RdfTypeLiteralTyped(this, dtype);
            } else {
                RdfClass tmp;
                targetRdfType = this.getOrAllocateRdfType(propertyType);
                if (targetRdfType instanceof RdfClass && !(tmp = (RdfClass)targetRdfType).isPopulated()) {
                    frontier.add((Object)tmp);
                }
            }
        } else {
            Assert.isTrue((boolean)String.class.isAssignableFrom(propertyType), (String)("propertyType expected to be (a subclass) of String - but got: " + String.valueOf(propertyType)));
            targetRdfType = new RdfTypeIriStr();
        }
        DefaultIri defaultIri = (DefaultIri)pd.findAnnotation(DefaultIri.class);
        if (defaultIri == null) {
            defaultIriFn = (entity, value) -> targetRdfType.getRootNode(value);
        } else {
            String defaultIriStr = defaultIri.value();
            Expression expression = this.parser.parseExpression(defaultIriStr, this.parserContext);
            Function defaultIriFnTmp = new F_GetValue<String>(String.class, expression, this.evalContext).andThen(iri -> NodeFactory.createURI((String)iri));
            defaultIriFn = (entity, value) -> (Node)defaultIriFnTmp.apply(entity);
        }
        TypeConverter typeConverter = null;
        Datatype dt = (Datatype)pd.findAnnotation(Datatype.class);
        if (dt != null && (typeConverter = this.typeConversionService.getConverter(dtName = this.resolveIriExpr(rawDtName = dt.value(), null), propertyType)) == null) {
            throw new RuntimeException("Could not find a type converter: " + dtName + " -> " + String.valueOf(propertyType));
        }
        RdfPropertyDescriptor descriptor = new RdfPropertyDescriptor(propertyName, targetRdfType, "");
        RdfMapperPropertyBase populator = isCollectionProperty ? new RdfMapperPropertyMulti(pd, predicate, targetRdfType, defaultIriFn, typeConverter) : new RdfMapperPropertySingle(pd, predicate, targetRdfType, defaultIriFn, typeConverter);
        rdfClass.addPropertyDescriptor(descriptor);
        rdfClass.addPropertyMapper(populator);
    }

    public static RdfTypeFactoryImpl createDefault() {
        RdfTypeFactoryImpl result = RdfTypeFactoryImpl.createDefault(null);
        return result;
    }

    public static RdfTypeFactoryImpl createDefault(Prologue prologue) {
        RdfTypeFactoryImpl result = RdfTypeFactoryImpl.createDefault(prologue, null, null);
        return result;
    }

    public static RdfTypeFactoryImpl createDefault(Prologue prologue, Function<Class<?>, EntityOps> entityOpsFactory, ConversionService _conversionService) {
        ConversionService conversionService;
        Prologue prologue2 = prologue = prologue != null ? prologue : new Prologue();
        if (_conversionService == null) {
            DefaultConversionService dcs = new DefaultConversionService();
            conversionService = ConversionServiceAdapter.wrap((Object)dcs, (arg_0, arg_1) -> ((DefaultConversionService)dcs).canConvert(arg_0, arg_1), (arg_0, arg_1) -> ((DefaultConversionService)dcs).convert(arg_0, arg_1));
        } else {
            conversionService = _conversionService;
        }
        entityOpsFactory = entityOpsFactory != null ? entityOpsFactory : clazz -> EntityModel.createDefaultModel((Class)clazz, (ConversionService)conversionService);
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        TemplateParserContext parserContext = new TemplateParserContext();
        try {
            evalContext.registerFunction("md5", StringUtils.class.getDeclaredMethod("md5Hash", String.class));
            evalContext.registerFunction("localName", SplitIRI.class.getDeclaredMethod("localname", String.class));
            evalContext.registerFunction("nameSpace", SplitIRI.class.getDeclaredMethod("namespace", String.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        SparqlRelationParserImpl relationParser = SparqlRelationParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)prologue);
        TypeMapper typeMapper = TypeMapper.getInstance();
        RdfTypeFactoryImpl result = new RdfTypeFactoryImpl((ExpressionParser)parser, (ParserContext)parserContext, (EvaluationContext)evalContext, typeMapper, prologue, (SparqlRelationParser)relationParser, entityOpsFactory, conversionService);
        result.getClassToRdfType().put(Map.class, new RdfTypeMap(x -> (Map)x));
        result.getClassToRdfType().put(Node.class, new RdfTypeNode());
        return result;
    }
}

