/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.mapper.model.TypeDecider;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.apache.jena.rdf.model.Resource;

public class TypeDeciderCompound
implements TypeDecider {
    protected List<TypeDecider> delegates;

    public TypeDeciderCompound() {
        this(new ArrayList<TypeDecider>());
    }

    public TypeDeciderCompound(List<TypeDecider> delegates) {
        this.delegates = delegates;
    }

    public List<TypeDecider> getDelegates() {
        return this.delegates;
    }

    @Override
    public void exposeShape(ResourceShapeBuilder rsb) {
        for (TypeDecider delegate : this.delegates) {
            delegate.exposeShape(rsb);
        }
    }

    @Override
    public void exposeShape(ResourceShapeBuilder rsb, Class<?> clazz) {
        for (TypeDecider delegate : this.delegates) {
            delegate.exposeShape(rsb, clazz);
        }
    }

    @Override
    public Collection<Class<?>> getApplicableTypes(Resource subject) {
        TypeDecider delegate;
        Collection<Class<?>> result = null;
        Iterator<TypeDecider> iterator = this.delegates.iterator();
        while (iterator.hasNext() && (result = (delegate = iterator.next()).getApplicableTypes(subject)) == null) {
        }
        result = result == null ? Collections.emptySet() : null;
        return result;
    }

    @Override
    public void writeTypeTriples(Resource outResource, Class<?> clazz) {
        for (TypeDecider delegate : this.delegates) {
            delegate.writeTypeTriples(outResource, clazz);
        }
    }
}

