/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.type;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.aksw.jena_sparql_api.mapper.impl.type.EntityFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PlaceholderInfo;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeComplexBase;
import org.aksw.jena_sparql_api.mapper.impl.type.ResolutionTask;
import org.aksw.jena_sparql_api.mapper.impl.type.ResolutionTaskBase;
import org.aksw.jena_sparql_api.mapper.impl.type.ResourceFragment;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;

public class RdfTypeMap
extends RdfTypeComplexBase {
    public static final Property entry = ResourceFactory.createProperty((String)"http://jsa.aksw.org/ontology/entry");
    public static final Property key = ResourceFactory.createProperty((String)"http://jsa.aksw.org/ontology/key");
    public static final Property value = ResourceFactory.createProperty((String)"http://jsa.aksw.org/ontology/value");
    protected RdfType keyRdfType;
    protected RdfType valueRdfType;
    protected Class<?> keyClazz;
    protected Class<?> valueClazz;
    protected Function<Object, Map> createMapView;

    public RdfTypeMap(Function<Object, Map> createMapView) {
        this(createMapView, Object.class, Object.class);
    }

    public RdfTypeMap(Function<Object, Map> createMapView, RdfType keyRdfType, RdfType valueRdfType) {
        this.createMapView = createMapView;
        this.keyRdfType = keyRdfType;
        this.valueRdfType = valueRdfType;
    }

    public RdfTypeMap(Function<Object, Map> createMapView, Class<?> keyClazz, Class<?> valueClazz) {
        this.createMapView = createMapView;
        this.keyClazz = keyClazz;
        this.valueClazz = valueClazz;
    }

    @Override
    public void exposeShape(ResourceShapeBuilder shapeBuilder) {
        ResourceShapeBuilder tmp = shapeBuilder.out(entry.asNode());
        tmp.out(key.asNode());
        tmp.out(value.asNode());
    }

    @Override
    public void exposeFragment(ResourceFragment out, Resource priorState, Object entity) {
        Map map = this.createMapView.apply(entity);
        int i = 1;
        for (Map.Entry e : map.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            Resource subject = out.getResource();
            Model m = subject.getModel();
            Resource r = m.createResource(priorState.getURI() + "-" + i);
            Resource kNode = m.createResource();
            Resource vNode = m.createResource();
            subject.addProperty(entry, (RDFNode)r);
            r.addProperty(key, (RDFNode)kNode).addProperty(value, (RDFNode)vNode);
            out.getPlaceholders().put((RDFNode)kNode, new PlaceholderInfo(this.keyClazz, null, entity, null, null, k, null, null));
            out.getPlaceholders().put((RDFNode)vNode, new PlaceholderInfo(this.valueClazz, null, entity, null, null, v, null, null));
            ++i;
        }
    }

    @Override
    public EntityFragment populate(Resource shape, Object entity) {
        final Map map = this.createMapView.apply(entity);
        EntityFragment result = new EntityFragment(entity);
        for (Statement stmt : shape.listProperties(entry).toList()) {
            Resource e = stmt.getObject().asResource();
            Statement kStmt = e.getProperty(key);
            Statement vStmt = e.getProperty(value);
            if (kStmt == null || vStmt == null) continue;
            RDFNode kNode = kStmt.getObject();
            RDFNode vNode = vStmt.getObject();
            PlaceholderInfo kPlaceholder = new PlaceholderInfo(this.keyClazz, null, entity, (RDFNode)shape, null, null, kNode, null);
            PlaceholderInfo vPlaceholder = new PlaceholderInfo(this.valueClazz, null, entity, (RDFNode)shape, null, null, vNode, null);
            List<PlaceholderInfo> entryPlaceholders = Arrays.asList(kPlaceholder, vPlaceholder);
            ResolutionTaskBase<PlaceholderInfo> task = new ResolutionTaskBase<PlaceholderInfo>(entryPlaceholders){

                @Override
                public Collection<ResolutionTask<PlaceholderInfo>> resolve(List<Object> resolutions) {
                    Object k = resolutions.get(0);
                    Object v = resolutions.get(1);
                    map.put(k, v);
                    return Collections.emptyList();
                }
            };
            result.getTasks().add((ResolutionTask<PlaceholderInfo>)task);
        }
        return result;
    }

    @Override
    public Class<?> getEntityClass() {
        return Map.class;
    }

    @Override
    public Node getRootNode(Object obj) {
        return null;
    }

    @Override
    public Object createJavaObject(RDFNode node) {
        HashMap result = new HashMap();
        return result;
    }

    @Override
    public boolean hasIdentity() {
        return false;
    }

    @Override
    public PathFragment resolve(String propertyName) {
        PathFragment result = "key".equals(propertyName) ? new PathFragment(FragmentUtils.createRelation((Property)key, (boolean)false), this.keyClazz, this.keyRdfType, null) : ("value".equals(propertyName) ? new PathFragment(FragmentUtils.createRelation((Property)value, (boolean)false), this.keyClazz, this.valueRdfType, null) : null);
        return result;
    }
}

