/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.engine;

import com.google.common.collect.ArrayListMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.beans.model.EntityOps;
import org.aksw.commons.beans.model.PropertyOps;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.commons.util.reflect.ClassUtils;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.aksw.jena_sparql_api.mapper.context.EntityId;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.impl.engine.EntityState;
import org.aksw.jena_sparql_api.mapper.impl.engine.PathResolverImpl;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngineBatched;
import org.aksw.jena_sparql_api.mapper.impl.type.EntityFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathResolver;
import org.aksw.jena_sparql_api.mapper.impl.type.PlaceholderInfo;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.ResolutionTask;
import org.aksw.jena_sparql_api.mapper.impl.type.ResourceFragment;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperProperty;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.mapper.model.ShapeExposable;
import org.aksw.jena_sparql_api.mapper.model.TypeDecider;
import org.aksw.jena_sparql_api.mapper.model.TypeDeciderImpl;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.shape.lookup.MapServiceResourceShape;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfMapperEngineImpl
implements RdfMapperEngineBatched {
    private static final Logger logger = LoggerFactory.getLogger(RdfMapperEngineBatched.class);
    protected Prologue prologue;
    protected SparqlService sparqlService;
    protected RdfTypeFactory typeFactory;
    protected Map<EntityId, EntityState> originalState = Collections.synchronizedMap(new HashMap());
    protected TypeDecider typeDecider = new TypeDeciderImpl();

    @Override
    public SparqlService getSparqlService() {
        return this.sparqlService;
    }

    @Override
    public TypeDecider getTypeDecider() {
        return this.typeDecider;
    }

    public RdfMapperEngineImpl(SparqlService sparqlService) {
        this(sparqlService, RdfTypeFactoryImpl.createDefault(), new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, Prologue prologue) {
        this(sparqlService, RdfTypeFactoryImpl.createDefault(prologue), prologue, null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory) {
        this(sparqlService, typeFactory, new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue) {
        this(sparqlService, typeFactory, prologue, null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue, RdfPersistenceContext persistenceContext) {
        this.sparqlService = sparqlService;
        this.typeFactory = typeFactory;
        this.prologue = prologue;
    }

    public RdfTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Prologue getPrologue() {
        return this.prologue;
    }

    public <T> LookupService<Node, T> getLookupService(Class<T> clazz) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIri(Object entity) {
        String result = null;
        Map<EntityId, EntityState> map = this.originalState;
        synchronized (map) {
            for (EntityState entityState : this.originalState.values()) {
                if (entityState.getEntity() != entity) continue;
                RDFNode tmp = entityState.getShapeResource();
                if (tmp != null && tmp.isResource()) {
                    result = tmp.asResource().getURI();
                    break;
                }
                throw new RuntimeException("Entity exists but does not have an IRI - should not happen");
            }
        }
        return result;
    }

    @Override
    public <T> List<T> list(Class<T> clazz, Concept filterConcept) {
        RDFConnection qef = this.sparqlService.getRDFConnection();
        List nodes = ServiceUtils.fetchList((SparqlQueryConnection)qef, (Fragment1)filterConcept);
        Map<Node, T> map = this.find(clazz, nodes);
        List result = nodes.stream().map(map::get).collect(Collectors.toList());
        return result;
    }

    @Override
    public <T> Map<Node, T> find(Class<T> clazz, Collection<Node> nodes) {
        Map<Node, EntityState> nodeToState = this.loadEntities(clazz, nodes);
        Map<Node, Object> result = nodeToState.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((EntityState)e.getValue()).getEntity()));
        return result;
    }

    public static Map<Node, RDFNode> fetch(Prologue prologue, SparqlService sparqlService, ShapeExposable shapeSupplier, Collection<Node> nodes) {
        Map<Node, RDFNode> result;
        ResourceShapeBuilder builder = new ResourceShapeBuilder(prologue);
        shapeSupplier.exposeShape(builder);
        ResourceShape shape = builder.getResourceShape();
        if (!shape.isEmpty()) {
            QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
            LookupService ls = MapServiceResourceShape.createLookupService((QueryExecutionFactoryQuery)qef, (ResourceShape)shape);
            Map map = ls.fetchMap(nodes);
            result = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                Model m = ModelFactory.createModelForGraph((Graph)((Graph)e.getValue()));
                RDFNode r = ModelUtils.convertGraphNodeToRDFNode((Node)((Node)e.getKey()), (Model)m);
                return r;
            }));
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public <T> T find(Class<T> clazz, Node node) {
        Object o;
        Map<Node, EntityState> nodeToState = this.loadEntities(clazz, Collections.singleton(node));
        EntityState es = nodeToState.get(node);
        Object result = o = es.getEntity();
        return (T)result;
    }

    public static RDFNode copy(RDFNode source) {
        RDFNode result = source.inModel(ModelFactory.createDefaultModel().add(source.getModel()));
        return result;
    }

    public Map<Node, EntityState> loadEntities(Class<?> clazz, Collection<Node> nodes) {
        Objects.requireNonNull(clazz);
        List<Node> pendingLoad = nodes.stream().filter(node -> {
            EntityId entityId = new EntityId(clazz, (Node)node);
            EntityState entityState = this.originalState.get(entityId);
            Object entity = entityState == null ? null : entityState.getEntity();
            boolean r = entity == null;
            return r;
        }).collect(Collectors.toList());
        Map<Node, RDFNode> nodeToRdfNode = RdfMapperEngineImpl.fetch(this.prologue, this.sparqlService, this.typeDecider, pendingLoad);
        Map<Node, Class> nodeToClass = nodeToRdfNode.entrySet().stream().map(e -> {
            Node node = (Node)e.getKey();
            RDFNode rdfNode = (RDFNode)e.getValue();
            if (rdfNode == null) {
                throw new RuntimeException("Could not determine type for node " + String.valueOf(node));
            }
            Collection<Class<?>> classes = this.typeDecider.getApplicableTypes(rdfNode.asResource());
            Set mscs = ClassUtils.getMostSpecificSubclasses((Class)clazz, classes);
            if (mscs.isEmpty()) {
                throw new RuntimeException("No applicable type found for " + String.valueOf(node) + " [" + clazz.getName() + "]");
            }
            if (mscs.size() > 1) {
                throw new RuntimeException("Multiple non-subsumed sub-class candidates of " + String.valueOf(clazz) + " found: " + String.valueOf(mscs));
            }
            Class r = (Class)mscs.iterator().next();
            return new AbstractMap.SimpleEntry<Node, Class>(node, r);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<EntityFragment> entityFragments = new ArrayList<EntityFragment>();
        ArrayListMultimap nodesByClass = ArrayListMultimap.create();
        ArrayListMultimap nodesByClassToLoad = ArrayListMultimap.create();
        for (Node node2 : nodes) {
            EntityId entityId = new EntityId(clazz, node2);
            EntityState entityState = this.originalState.get(entityId);
            Object entity = entityState == null ? null : entityState.getEntity();
            Class<?> actualClazz = nodeToClass.getOrDefault(node2, clazz);
            nodesByClass.put(actualClazz, (Object)node2);
            if (entity != null) continue;
            nodesByClassToLoad.put(actualClazz, (Object)node2);
        }
        for (Map.Entry entry : nodesByClass.asMap().entrySet()) {
            Class actualClazz = (Class)entry.getKey();
            Collection _nodes = (Collection)entry.getValue();
            Collection nodesToLoad = nodesByClassToLoad.get((Object)actualClazz);
            RdfType rdfType = this.typeFactory.forJavaType(actualClazz);
            Map<Node, RDFNode> backendStates = RdfMapperEngineImpl.fetch(this.prologue, this.sparqlService, rsb -> {
                rdfType.exposeShape(rsb);
                this.typeDecider.exposeShape(rsb);
            }, nodesToLoad);
            for (Node node3 : _nodes) {
                EntityFragment entityFragment;
                RDFNode workingState;
                RDFNode backendState;
                Object entity;
                EntityId entityId = new EntityId(clazz, node3);
                EntityState entityState = this.originalState.get(entityId);
                Object object = entity = entityState == null ? null : entityState.getEntity();
                if (entity == null) {
                    backendState = backendStates.get(node3);
                    if (backendState == null) {
                        backendState = ModelUtils.convertGraphNodeToRDFNode((Node)node3, (Model)ModelFactory.createDefaultModel());
                    }
                    workingState = RdfMapperEngineImpl.copy(backendState);
                    entity = rdfType.createJavaObject(workingState);
                } else {
                    backendState = entityState.getShapeResource();
                    workingState = entityState.getCurrentResource();
                    if (workingState == null) {
                        throw new RuntimeException("should not happen");
                    }
                }
                if (workingState.isResource()) {
                    Resource r = workingState.asResource();
                    entityFragment = rdfType.populate(r, entity);
                    Class<?> entityClass = entity.getClass();
                    this.typeDecider.writeTypeTriples(r, entityClass);
                    entityFragments.add(entityFragment);
                } else {
                    entityFragment = new EntityFragment(entity);
                    entityFragments.add(entityFragment);
                }
                ResourceFragment resourceFragment = null;
                EntityState result = new EntityState(entity, backendState, workingState, resourceFragment, entityFragment);
                this.originalState.merge(entityId, result, (? super V o, ? super V n) -> {
                    n.getDependentEntityIds().addAll(o.getDependentEntityIds());
                    return n;
                });
            }
        }
        this.populateEntities(entityFragments);
        HashMap<Node, EntityState> result = new HashMap<Node, EntityState>();
        nodes.forEach(node -> result.put((Node)node, this.originalState.get(new EntityId(clazz, (Node)node))));
        return result;
    }

    void populateEntities(Collection<EntityFragment> entityFragments) {
        ArrayList<Object> resolution;
        ArrayListMultimap entityIdsByClass = ArrayListMultimap.create();
        List tasks = entityFragments.stream().map(EntityFragment::getTasks).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList taskParams = new ArrayList(tasks.size());
        ArrayList taskResolutions = new ArrayList(tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            ResolutionTask task = (ResolutionTask)tasks.get(i);
            List list = task.getPlaceholders();
            ArrayList<EntityId> params = new ArrayList<EntityId>(list.size());
            taskParams.add(params);
            resolution = new ArrayList(list.size());
            taskResolutions.add(resolution);
            for (int j = 0; j < list.size(); ++j) {
                PlaceholderInfo placeholder = (PlaceholderInfo)list.get(j);
                RdfType targetRdfType = placeholder.getTargetRdfType();
                Class<?> valueClass = targetRdfType != null ? targetRdfType.getEntityClass() : placeholder.getTargetClass();
                Objects.requireNonNull(valueClass);
                RDFNode valueRdfNode = placeholder.getRdfNode();
                if (valueRdfNode != null) {
                    if (targetRdfType != null && targetRdfType.isSimpleType()) {
                        Object obj = targetRdfType.createJavaObject(valueRdfNode);
                        params.add(null);
                        resolution.add(obj);
                        continue;
                    }
                    Node valueNode = valueRdfNode.asNode();
                    EntityId entityId = new EntityId(valueClass, valueNode);
                    entityIdsByClass.put(valueClass, (Object)entityId);
                    params.add(entityId);
                    resolution.add(null);
                    continue;
                }
                params.add(null);
                resolution.add(null);
            }
        }
        HashMap nodeToState = new HashMap();
        for (Map.Entry entry : entityIdsByClass.asMap().entrySet()) {
            Class valueClass = (Class)entry.getKey();
            Collection entityIds = (Collection)entry.getValue();
            Collection nodes = entityIds.stream().map(EntityId::getNode).collect(Collectors.toList());
            Map<Node, EntityState> tmpNodeToState = this.loadEntities((Class)entry.getKey(), nodes);
            tmpNodeToState.forEach((node, state) -> nodeToState.put(new EntityId(valueClass, (Node)node), state));
        }
        for (int i = 0; i < tasks.size(); ++i) {
            ResolutionTask resolutionTask = (ResolutionTask)tasks.get(i);
            List paramEntityIds = (List)taskParams.get(i);
            resolution = (List)taskResolutions.get(i);
            for (int j = 0; j < paramEntityIds.size(); ++j) {
                EntityId entityId = (EntityId)paramEntityIds.get(j);
                if (entityId == null) continue;
                EntityState state2 = (EntityState)nodeToState.get(entityId);
                Object value = state2 == null ? null : state2.getEntity();
                resolution.set(j, value);
            }
            Collection newTasks = resolutionTask.resolve(resolution);
            if (newTasks.isEmpty()) continue;
            throw new UnsupportedOperationException("not implemented yet :(");
        }
    }

    @Override
    public <T> T merge(T tmpEntity) {
        RdfType rootRdfType = this.typeFactory.forJavaType(tmpEntity.getClass());
        Node node = rootRdfType.getRootNode(tmpEntity);
        T result = this.merge(tmpEntity, node);
        return result;
    }

    public Object find(EntityId entityId) {
        Class<?> entityClass = entityId.getEntityClass();
        Node node = entityId.getNode();
        Object result = this.find(entityClass, node);
        return result;
    }

    @Override
    public void remove(Object entity) {
        Class<?> entityClazz = entity.getClass();
        RdfType rdfType = this.typeFactory.forJavaType(entityClazz);
        Node node = rdfType.getRootNode(entity);
        this.remove(node, entityClazz);
    }

    @Override
    public void remove(Node node, Class<?> clazz) {
        EntityState entityState = this.loadEntity(clazz, node);
        for (EntityId entityId : entityState.getDependentEntityIds()) {
            this.remove(entityId.getNode(), entityId.getEntityClass());
        }
        entityState.setCurrentResource(entityState.getShapeResource().inModel(ModelFactory.createDefaultModel()));
        this.commit();
    }

    public EntityState loadEntity(Class<?> clazz, Node node) {
        Map<Node, EntityState> nodeToState = this.loadEntities(clazz, Collections.singleton(node));
        EntityState result = nodeToState.get(node);
        return result;
    }

    @Override
    public <T> T merge(T srcEntity, Node node) {
        T result = this.merge(srcEntity, node, null);
        return result;
    }

    public <T> T merge(T srcEntity, Node node, Class<?> entityClass) {
        Object entity;
        EntityId entityId = this.merge(srcEntity, node, entityClass, null);
        EntityState entityState = this.originalState.get(entityId);
        Object result = entity = entityState == null ? null : entityState.getEntity();
        return (T)result;
    }

    public EntityId merge(Object srcEntity, Node node, Class<?> entityClass, RdfType rdfClass) {
        Objects.requireNonNull(srcEntity);
        Objects.requireNonNull(node);
        entityClass = entityClass != null ? entityClass : srcEntity.getClass();
        rdfClass = rdfClass != null ? rdfClass : this.typeFactory.forJavaType(entityClass);
        Function<Class<?>, EntityOps> entityOpsFactory = ((RdfTypeFactoryImpl)this.typeFactory).getEntityOpsFactory();
        EntityId entityId = new EntityId(entityClass, node);
        EntityState entityState = this.loadEntity(entityClass, node);
        Object tgtEntity = entityState.getEntity();
        Resource priorState = entityState.getShapeResource().asResource();
        ResourceFragment r = new ResourceFragment();
        rdfClass.exposeFragment(r, priorState, srcEntity);
        Resource exposedS = r.getResource();
        Map<RDFNode, PlaceholderInfo> placeholders = r.getPlaceholders();
        Model resolvedModel = ModelFactory.createDefaultModel();
        Resource unresolvedRoot = r.getResource();
        Resource resolvedRoot = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)resolvedModel).asResource();
        Set<Resource> current = Collections.singleton(r.getResource());
        HashSet<Object> next = new HashSet<Resource>();
        HashSet visited = new HashSet();
        HashMap<Object, Object> resolutions = new HashMap<Object, Object>();
        resolutions.put(unresolvedRoot, resolvedRoot);
        while (!current.isEmpty()) {
            for (RDFNode rDFNode : current) {
                if (visited.contains(rDFNode) || !rDFNode.isResource()) continue;
                Resource fragS = rDFNode.asResource();
                for (Statement fragStmt : fragS.listProperties().toList()) {
                    RDFNode o;
                    Property p = fragStmt.getPredicate();
                    RDFNode fragO = fragStmt.getObject();
                    if (fragO != null && fragO.isResource()) {
                        next.add((Resource)fragO);
                    }
                    Resource s = ((RDFNode)resolutions.get(fragS)).asResource();
                    PlaceholderInfo info = placeholders.get(fragO);
                    if (info != null) {
                        Node n;
                        boolean hasDependentIdentity;
                        Object entity = info.getValue();
                        Class<?> valueClass = entity != null ? entity.getClass() : info.getTargetClass();
                        boolean reuseIri = true;
                        Statement reusedStmt = fragS.getProperty(p);
                        RDFNode reusedO = reusedStmt == null ? null : reusedStmt.getObject();
                        RdfType targetRdfType = info.getTargetRdfType();
                        RdfMapperProperty propertyMapper = info.getMapper();
                        PropertyOps pops = propertyMapper != null ? propertyMapper.getPropertyOps() : null;
                        targetRdfType = targetRdfType != null ? targetRdfType : this.typeFactory.forJavaType(valueClass);
                        boolean bl = hasDependentIdentity = !targetRdfType.isSimpleType() && !targetRdfType.hasIdentity();
                        Node node2 = propertyMapper != null && hasDependentIdentity ? propertyMapper.getTargetNode(s.getURI(), entity) : (n = entity != null ? targetRdfType.getRootNode(entity) : null);
                        if (n != null) {
                            o = ModelUtils.convertGraphNodeToRDFNode((Node)n, (Model)resolvedModel);
                            if (o.isResource() && !targetRdfType.isSimpleType()) {
                                EntityId valueEntityId = this.merge(entity, n, valueClass, targetRdfType);
                                if (hasDependentIdentity) {
                                    entityState.getDependentEntityIds().add(valueEntityId);
                                }
                            }
                        } else {
                            o = null;
                        }
                    } else {
                        o = fragO.inModel(resolvedModel);
                    }
                    if (o == null) continue;
                    resolutions.put(fragO, o);
                    s.addProperty(p, o);
                }
            }
            current = next;
            next = new HashSet();
        }
        Resource resolvedS = ((RDFNode)resolutions.get(exposedS)).asResource();
        this.typeDecider.writeTypeTriples(resolvedS, entityClass);
        EntityFragment entityFragment = rdfClass.populate(resolvedS, tgtEntity);
        if (entityFragment == null) {
            throw new NullPointerException("Population must not return a null fragment, Error might be in the implementation of " + String.valueOf(rdfClass.getClass()));
        }
        this.populateEntities(Collections.singleton(entityFragment));
        entityState.setCurrentResource((RDFNode)resolvedS);
        this.commit();
        EntityId result = entityId;
        return result;
    }

    public void commit() {
        DatasetDescription datasetDescription = this.sparqlService.getDatasetDescription();
        String gStr = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        if (gStr == null) {
            throw new RuntimeException("No target graph specified");
        }
        Node g = NodeFactory.createURI((String)gStr);
        DatasetGraph oldState = DatasetGraphFactory.create();
        DatasetGraph newState = DatasetGraphFactory.create();
        for (Map.Entry<EntityId, EntityState> e : this.originalState.entrySet()) {
            EntityState state = e.getValue();
            RDFNode current = state.getCurrentResource();
            if (current == null) continue;
            Graph oldGraph = state.getShapeResource().getModel().getGraph();
            Graph newGraph = current.getModel().getGraph();
            oldState.addGraph(g, oldGraph);
            newState.addGraph(g, newGraph);
        }
        Diff diff = UpdateDiffUtils.computeDelta((DatasetGraph)newState, (DatasetGraph)oldState);
        if (!((Set)diff.getRemoved()).isEmpty()) {
            System.out.println("Removed: " + String.valueOf(diff.getRemoved()));
        }
        System.out.println("Applying diff: " + String.valueOf(diff));
        UpdateExecutionFactory uef = this.sparqlService.getUpdateExecutionFactory();
        UpdateExecutionUtils.executeUpdate((UpdateExecutionFactory)uef, (Diff)diff);
        for (Map.Entry<EntityId, EntityState> e : this.originalState.entrySet()) {
            e.getValue().shapeResource = RdfMapperEngineImpl.copy(e.getValue().getCurrentResource());
        }
    }

    @Override
    public RdfTypeFactory getRdfTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public PathResolver createResolver(Class<?> javaClass) {
        PathFragment pathFragment = new PathFragment(Fragment2Impl.empty((Var)Var.alloc((String)"root")), javaClass, null, null);
        PathResolverImpl result = new PathResolverImpl(pathFragment, this, null, null);
        return result;
    }
}

