/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.reprogen.hashid.HashIdCxt;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.Closure;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.system.G;
import org.apache.jena.util.ResourceUtils;

public class Skolemize {
    public static final Property skolemId = ResourceFactory.createProperty((String)"http://tmp.aksw.org/skolemId");

    public static void skolemize2(Resource r) {
    }

    public static void skolemize(Resource r) {
        if (!r.isURIResource()) {
            throw new RuntimeException("This skolemization function requires a URI resource as input");
        }
        String baseUri = r.getURI();
        Model model = r.getModel();
        Model closure = Closure.closure((Resource)r, (boolean)false);
        Graph g = closure.getGraph();
        Iterable allNodes = () -> GraphUtils.allNodes((Graph)g);
        Set blankNodes = StreamSupport.stream(allNodes.spliterator(), false).filter(x -> x.isBlank() || x.isVariable()).collect(Collectors.toSet());
        NodeTransform unifyBlankNodes = node -> node.isBlank() || node.isVariable() ? Vars.a : node;
        Map<Node, Node> nodeToLocalHash = blankNodes.stream().collect(Collectors.toMap(x -> x, x -> NodeFactory.createLiteral((String)Skolemize.createSignature(g, x, (Function<? super Node, ? extends Node>)unifyBlankNodes))));
        Map<Node, String> nodeToGlobalHash = blankNodes.stream().collect(Collectors.toMap(x -> x, x -> Skolemize.createSignature(g, x, node -> nodeToLocalHash.getOrDefault(node, (Node)node))));
        Map<Resource, String> map = blankNodes.stream().collect(Collectors.toMap(n -> (Resource)ModelUtils.convertGraphNodeToRDFNode((Node)n, (Model)model), n -> ((String)nodeToGlobalHash.get(n)).substring(0, 8)));
        map.entrySet().forEach(e -> ((Resource)e.getKey()).addLiteral(skolemId, e.getValue()));
        map.entrySet().forEach(e -> ResourceUtils.renameResource((Resource)((Resource)e.getKey()), (String)(baseUri + "-bn" + (String)e.getValue())));
    }

    public static String createSignature(Graph g, Node n, Function<? super Node, ? extends Node> nodeTransform) {
        List<Triple> rawSig = Skolemize.createRawSignature(g, n, nodeTransform);
        String result = StringUtils.md5Hash((String)String.valueOf(rawSig));
        return result;
    }

    public static List<Triple> createRawSignature(Graph g, Node n, Function<? super Node, ? extends Node> nodeTransform) {
        List triples = g.find(n, Node.ANY, Node.ANY).andThen((Iterator)g.find(Node.ANY, Node.ANY, n)).toList();
        NodeTransform fn = node -> (Node)nodeTransform.apply((Node)node);
        List<Triple> result = triples.stream().map(triple -> NodeTransformLib.transform((NodeTransform)fn, (Triple)triple)).sorted((a, b) -> String.valueOf(a).compareTo(String.valueOf(b))).collect(Collectors.toList());
        return result;
    }

    public static <T extends RDFNode> T skolemize(Resource root, String baseIri, Class<T> cls, BiConsumer<Resource, Map<Node, Node>> postProcessor) {
        return Skolemize.skolemize(root, null, baseIri, cls, postProcessor);
    }

    public static <T extends RDFNode> T skolemize(Resource root, Model staticModel, String baseIri, Class<T> cls) {
        return Skolemize.skolemize(root, staticModel, baseIri, cls, null);
    }

    public static <T extends RDFNode> T skolemize(Resource root, Model staticModel, String baseIri, Class<T> cls, BiConsumer<Resource, Map<Node, Node>> postProcessor) {
        Graph staticGraph = staticModel != null ? staticModel.getGraph() : null;
        Resource mergedRoot = staticModel != null && root.getModel() != staticModel ? root.inModel(ModelFactory.createUnion((Model)root.getModel(), (Model)staticModel)) : root;
        RDFNode q = mergedRoot.as(cls);
        HashIdCxt hashIdCxt = MapperProxyUtils.getHashId(q);
        Map<Node, Node> renames = hashIdCxt.getNodeMapping(baseIri);
        Set blockedRenames = staticGraph == null ? Set.of() : renames.keySet().stream().filter(n -> G.containsNode((Graph)staticGraph, (Node)n)).collect(Collectors.toSet());
        Node newRoot = renames.get(q.asNode());
        Model rootModel = root.getModel();
        NodeTransformLib2.applyNodeTransform((NodeTransform)NodeTransformLib2.wrapWithNullAsIdentity(n -> blockedRenames.contains(n) ? null : (Node)renames.get(n)), (Model)rootModel);
        Resource resultRes = rootModel.asRDFNode(newRoot).asResource();
        if (postProcessor != null) {
            postProcessor.accept(resultRes, renames);
        }
        RDFNode result = resultRes.as(cls);
        return (T)result;
    }
}

