/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDecider;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDeciderImpl;
import org.aksw.jena_sparql_api.rdf.collections.RDFNodeMapperImpl;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.arq.util.implementation.ImplementationLazy;
import org.aksw.jenax.arq.util.implementation.SimpleImplementation;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.reprogen.util.ImplementationProxy;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaPluginUtils {
    private static final Logger logger = LoggerFactory.getLogger(JenaPluginUtils.class);
    protected static TypeDeciderImpl typeDecider;

    public static <T extends RDFNode> T polymorphicCast(RDFNode rdfNode, Class<T> viewClass, TypeDecider typeDecider) {
        RDFNode result = RDFNodeMapperImpl.castRdfNode((RDFNode)rdfNode, viewClass, (TypeDecider)typeDecider, (boolean)false, (boolean)false);
        return (T)result;
    }

    public static <T extends RDFNode> T polymorphicCast(RDFNode rdfNode, Class<T> viewClass) {
        TypeDecider typeDecider = JenaPluginUtils.getTypeDecider();
        RDFNode result = RDFNodeMapperImpl.castRdfNode((RDFNode)rdfNode, viewClass, (TypeDecider)typeDecider, (boolean)false, (boolean)false);
        return (T)result;
    }

    public static <T extends RDFNode> T polymorphicCast(RDFNode rdfNode) {
        TypeDecider typeDecider = JenaPluginUtils.getTypeDecider();
        Collection candidateClasses = typeDecider.getApplicableTypes(rdfNode.asResource());
        Class clz = (Class)IterableUtils.expectOneItem((Iterable)candidateClasses);
        T result = JenaPluginUtils.polymorphicCast(rdfNode, clz, typeDecider);
        return result;
    }

    public static <T extends RDFNode> T inModel(T rdfNode, Class<T> viewClass, Model target) {
        RDFNode r = rdfNode.inModel(target);
        T result = JenaPluginUtils.polymorphicCast(r, viewClass);
        return result;
    }

    public static <T extends Resource> T copyInto(T rdfNode, Class<T> viewClass, Model target) {
        Model m = rdfNode.getModel();
        target.add(m);
        T result = JenaPluginUtils.inModel(rdfNode, viewClass, target);
        return result;
    }

    public static <T extends RDFNode> T copyClosureInto(T rdfNode, Class<T> viewClass, Model target) {
        if (rdfNode.isResource()) {
            Resource r = rdfNode.asResource();
            Model closure = ResourceUtils.reachableClosure((Resource)r);
            target.add(closure);
        }
        T result = JenaPluginUtils.inModel(rdfNode, viewClass, target);
        return result;
    }

    public static <T extends RDFNode> T reachableClosure(T rdfNode, Class<T> viewClass) {
        Model target;
        if (rdfNode.isResource()) {
            Resource r = rdfNode.asResource();
            target = ResourceUtils.reachableClosure((Resource)r);
        } else {
            target = ModelFactory.createDefaultModel();
        }
        T result = JenaPluginUtils.inModel(rdfNode, viewClass, target);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeDecider getTypeDecider() {
        if (typeDecider != null) return typeDecider;
        Class<JenaPluginUtils> clazz = JenaPluginUtils.class;
        synchronized (JenaPluginUtils.class) {
            if (typeDecider != null) return typeDecider;
            typeDecider = new TypeDeciderImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return typeDecider;
        }
    }

    public static void scan(Class<?> prototypeClass) {
        String basePackage = prototypeClass.getPackage().getName();
        JenaPluginUtils.scan(basePackage, (Personality<RDFNode>)BuiltinPersonalities.model);
    }

    public static void scan(String basePackage) {
        JenaPluginUtils.scan(basePackage, (Personality<RDFNode>)BuiltinPersonalities.model);
    }

    public static void scan(String basePackage, Personality<RDFNode> p) {
        JenaPluginUtils.scan(basePackage, p, DefaultPrefixes.get());
    }

    public static void scan(String basePackage, Personality<RDFNode> p, PrefixMapping pm) {
        ImmutableSet classInfos;
        try {
            classInfos = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getTopLevelClassesRecursive(basePackage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ClassPath.ClassInfo classInfo : classInfos) {
            Class clazz = classInfo.load();
            JenaPluginUtils.registerResourceClass(true, clazz, p, () -> pm);
        }
    }

    @SafeVarargs
    public static void registerResourceClasses(Class<? extends Resource> ... classes) {
        JenaPluginUtils.registerResourceClasses(true, classes);
    }

    public static void registerResourceClasses(Iterable<Class<?>> classes) {
        JenaPluginUtils.registerResourceClasses(true, classes);
    }

    @SafeVarargs
    public static void registerResourceClasses(Personality<RDFNode> personality, Class<? extends Resource> ... classes) {
        JenaPluginUtils.registerResourceClasses(personality, true, Arrays.asList(classes));
    }

    public static void registerResourceClasses(Personality<RDFNode> personality, Iterable<Class<?>> classes) {
        JenaPluginUtils.registerResourceClasses(personality, true, classes);
    }

    @SafeVarargs
    public static void registerResourceClasses(boolean lazy, Class<? extends Resource> ... classes) {
        JenaPluginUtils.registerResourceClasses((Personality<RDFNode>)BuiltinPersonalities.model, lazy, Arrays.asList(classes));
    }

    public static void registerResourceClasses(boolean lazy, Iterable<Class<?>> classes) {
        JenaPluginUtils.registerResourceClasses((Personality<RDFNode>)BuiltinPersonalities.model, lazy, classes);
    }

    @SafeVarargs
    public static void registerResourceClasses(Personality<RDFNode> personality, boolean lazy, Class<? extends Resource> ... classes) {
        JenaPluginUtils.registerResourceClasses(personality, lazy, Arrays.asList(classes));
    }

    public static void registerResourceClasses(Personality<RDFNode> personality, boolean lazy, Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            JenaPluginUtils.registerResourceClass(lazy, clazz, personality, () -> DefaultPrefixes.get());
        }
    }

    public static void registerResourceClass(Class<? extends Resource> inter, Class<?> impl) {
        boolean supportsProxying;
        Personality p = BuiltinPersonalities.model;
        if (Resource.class.isAssignableFrom(impl) && (supportsProxying = JenaPluginUtils.supportsProxying(impl))) {
            Class<?> cls = impl;
            p.add(inter, JenaPluginUtils.createImplementation(cls, DefaultPrefixes.get()));
        }
    }

    public static Implementation createDirectImplementation(Class<?> clazz) {
        SimpleImplementation result;
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            try {
                Constructor<?> ctor = clazz.getConstructor(Node.class, EnhGraph.class);
                result = new SimpleImplementation((n, g) -> {
                    try {
                        return (EnhNode)ctor.newInstance(n, g);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Resource implementation must provide the constructor (Node, EnhGraph)", e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Cannot register an abstract non-proxy class: " + String.valueOf(clazz));
        }
        return result;
    }

    public static Implementation createProxyImplementation(boolean lazy, Class<?> clazz, Supplier<PrefixMapping> pm) {
        TypeDecider typeDecider = JenaPluginUtils.getTypeDecider();
        ((TypeDeciderImpl)typeDecider).registerClasses(new Class[]{clazz});
        Object result = lazy ? new ImplementationLazy(() -> JenaPluginUtils.createImplementation(clazz, (PrefixMapping)pm.get()), clazz) : JenaPluginUtils.createImplementation(clazz, pm.get());
        return result;
    }

    public static Implementation createImplementation(Class<?> clazz, PrefixMapping pm) {
        Class<?> cls = clazz;
        TypeDecider typeDecider = JenaPluginUtils.getTypeDecider();
        if (logger.isDebugEnabled()) {
            logger.debug("Creating implementation for " + String.valueOf(clazz));
        }
        BiFunction<Node, EnhGraph, ?> proxyFactory = MapperProxyUtils.createProxyFactory(cls, pm, typeDecider);
        BiFunction<Node, EnhGraph, Resource> proxyFactory2 = (n, m) -> {
            ResourceImpl tmp = new ResourceImpl(n, m);
            typeDecider.writeTypeTriples((Resource)tmp, cls);
            Resource r = (Resource)proxyFactory.apply((Node)n, (EnhGraph)m);
            return r;
        };
        ImplementationProxy result = new ImplementationProxy(proxyFactory2);
        return result;
    }

    public static void registerResourceClass(boolean lazy, Class<?> clazz, Personality<RDFNode> p, Supplier<PrefixMapping> pm) {
        if (Resource.class.isAssignableFrom(clazz)) {
            Class[] classArray;
            Class[] rawSuperTypes;
            ResourceView resourceView = clazz.getAnnotation(ResourceView.class);
            Class[] classArray2 = rawSuperTypes = resourceView == null ? null : resourceView.value();
            if (rawSuperTypes == null || rawSuperTypes.length == 0) {
                Class[] classArray3 = new Class[1];
                classArray = classArray3;
                classArray3[0] = clazz;
            } else {
                classArray = rawSuperTypes;
            }
            Class[] superTypes = classArray;
            ArrayList<Class> effectiveTypes = new ArrayList<Class>(Arrays.asList(superTypes));
            boolean needsProxying = Modifier.isAbstract(clazz.getModifiers()) || JenaPluginUtils.supportsProxying(clazz);
            Implementation impl = needsProxying ? JenaPluginUtils.createProxyImplementation(lazy, clazz, pm) : JenaPluginUtils.createDirectImplementation(clazz);
            for (Class type : effectiveTypes) {
                if (!type.isAssignableFrom(clazz)) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Not a super type: Cannot register implementation for " + String.valueOf(clazz) + " with specified type " + String.valueOf(type));
                    continue;
                }
                Class cls = type;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering ResourceView from " + String.valueOf(clazz));
                }
                p.add(cls, impl);
            }
        }
    }

    public static boolean supportsProxying(Class<?> clazz) {
        boolean result = false;
        boolean bl = result = clazz.getAnnotation(ResourceView.class) != null;
        if (!result) {
            for (Method m : clazz.getDeclaredMethods()) {
                try {
                    Iri[] iris = (Iri[])m.getAnnotationsByType(Iri.class);
                    boolean bl2 = result = iris.length > 0;
                    if (!result) {
                        IriNs[] iriNss = (IriNs[])m.getAnnotationsByType(IriNs.class);
                        boolean bl3 = result = iriNss.length > 0;
                    }
                    if (!result) continue;
                    break;
                }
                catch (Exception e) {
                    e.addSuppressed(new RuntimeException("Error processing method " + String.valueOf(m)));
                    throw e;
                }
            }
        }
        return result;
    }

    public static <I extends RDFNode, O extends RDFNode> O getOrSet(I in, Class<O> clz, Supplier<? extends O> getter, Function<? super O, ?> setter) {
        RDFNode result = (RDFNode)getter.get();
        if (result == null) {
            result = in.getModel().createResource().as(clz);
            setter.apply(result);
        }
        return (O)result;
    }

    public static <I extends RDFNode, O extends RDFNode, C extends Collection<O>> O addNew(I in, Class<O> clz, Function<? super I, C> getCollection) {
        return (O)JenaPluginUtils.addNewCore(in, clz, () -> (Collection)getCollection.apply((Object)in), Collection::add);
    }

    public static <I extends RDFNode, X extends RDFNode, C> X addNewCore(I in, Class<X> clz, Supplier<C> getter, BiFunction<C, X, ?> adder) {
        C collection = getter.get();
        RDFNode item = in.getModel().createResource().as(clz);
        adder.apply(collection, item);
        return (X)item;
    }

    static {
        JenaSystem.init();
    }
}

