/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.hashid;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.BaseEncoding;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.aksw.jenax.reprogen.hashid.HashIdCxt;
import org.apache.jena.rdf.model.RDFNode;

public class HashIdCxtImpl
implements HashIdCxt {
    protected HashFunction hashFn;
    protected BiFunction<? super RDFNode, ? super HashIdCxt, ? extends HashCode> globalProcessor;
    protected Set<RDFNode> processing = new LinkedHashSet<RDFNode>();
    protected Set<RDFNode> pending = new LinkedHashSet<RDFNode>();
    protected Map<RDFNode, HashCode> rdfNodeToHashCode = new LinkedHashMap<RDFNode, HashCode>();
    protected Map<RDFNode, String> rdfNodeToString = new LinkedHashMap<RDFNode, String>();
    protected Function<HashCode, String> hashCodeEncoder;
    protected boolean useInnerIris = false;
    protected BiPredicate<? super RDFNode, ? super Integer> filterKeep = (rdfNode, depth) -> true;
    protected int depth;

    public HashIdCxtImpl(HashFunction hashFn, BiFunction<? super RDFNode, ? super HashIdCxt, ? extends HashCode> globalProcessor) {
        this.hashFn = hashFn;
        this.globalProcessor = globalProcessor;
        this.hashCodeEncoder = hashCode -> BaseEncoding.base64Url().omitPadding().encode(hashCode.asBytes());
        this.processing = new LinkedHashSet<RDFNode>();
    }

    @Override
    public boolean declareProcessing(RDFNode node) {
        boolean added = this.processing.add(node);
        if (!added && !this.rdfNodeToHashCode.containsKey(node)) {
            throw new IllegalStateException("Cyclic dependency; visited this node twice: " + String.valueOf(node.asResource()) + " " + String.valueOf(node.getClass()));
        }
        this.pending.remove(node);
        return added;
    }

    @Override
    public HashCode putHashId(RDFNode node, HashCode hashCode) {
        return this.rdfNodeToHashCode.put(node, hashCode);
    }

    @Override
    public HashCode getHashId(RDFNode node) {
        return this.rdfNodeToHashCode.get(node);
    }

    @Override
    public BiFunction<? super RDFNode, ? super HashIdCxt, ? extends HashCode> getGlobalProcessor() {
        return this.globalProcessor;
    }

    @Override
    public HashFunction getHashFunction() {
        return this.hashFn;
    }

    @Override
    public Map<RDFNode, HashCode> getHashIdMapping() {
        return this.rdfNodeToHashCode;
    }

    @Override
    public boolean isVisited(RDFNode node) {
        boolean result = this.processing.contains(node);
        return result;
    }

    @Override
    public String getStringId(RDFNode node) {
        return this.rdfNodeToString.get(node);
    }

    @Override
    public String putStringId(RDFNode node, String str) {
        return this.rdfNodeToString.put(node, str);
    }

    @Override
    public Map<RDFNode, String> getStringIdMapping() {
        return this.rdfNodeToString;
    }

    @Override
    public String getHashAsString(HashCode hashCode) {
        Objects.requireNonNull(hashCode, "hashCode should not be null here");
        String result = this.hashCodeEncoder.apply(hashCode);
        return result;
    }

    @Override
    public String getHashAsString(RDFNode rdfNode) {
        HashCode hashCode = this.getHashId(rdfNode);
        String result = hashCode == null ? null : this.getHashAsString(hashCode);
        return result;
    }

    @Override
    public boolean declarePending(RDFNode node) {
        boolean result = this.pending.add(node);
        return result;
    }

    @Override
    public boolean isPending(RDFNode node) {
        return this.pending.contains(node);
    }

    @Override
    public Set<RDFNode> getPending() {
        return this.pending;
    }
}

