/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.hashid;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.reprogen.hashid.HashIdCxt;
import org.aksw.jenax.reprogen.hashid.PropertyDescriptor;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.sparql.path.P_Path0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDescriptor {
    private static Logger logger = LoggerFactory.getLogger(ClassDescriptor.class);
    protected Class<?> clazz;
    protected Map<P_Path0, PropertyDescriptor> pathToPropertyDescriptor = Collections.synchronizedMap(new LinkedHashMap());
    protected Set<BiFunction<? super Resource, ? super HashIdCxt, ? extends HashCode>> directHashIdProcessors = new LinkedHashSet<BiFunction<? super Resource, ? super HashIdCxt, ? extends HashCode>>();
    protected Set<BiFunction<? super Resource, ? super HashIdCxt, ? extends String>> directStringIdProcessors = new LinkedHashSet<BiFunction<? super Resource, ? super HashIdCxt, ? extends String>>();

    public ClassDescriptor(Class<?> clazz) {
        this.clazz = clazz;
    }

    public PropertyDescriptor getOrCreatePropertyDescriptor(P_Path0 path) {
        PropertyDescriptor result = this.pathToPropertyDescriptor.computeIfAbsent(path, p -> new PropertyDescriptor(this, (P_Path0)p));
        return result;
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.pathToPropertyDescriptor.values();
    }

    public ClassDescriptor registerDirectHashIdProcessor(BiFunction<? super Resource, ? super HashIdCxt, ? extends HashCode> processor) {
        this.directHashIdProcessors.add(processor);
        return this;
    }

    public ClassDescriptor registerDirectStringIdProcessor(BiFunction<? super Resource, ? super HashIdCxt, ? extends String> processor) {
        this.directStringIdProcessors.add(processor);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCode computeHashId(Resource node, HashIdCxt cxt) {
        HashCode result;
        HashFunction hashFn = cxt.getHashFunction();
        Collection<PropertyDescriptor> pds = this.getPropertyDescriptors();
        Collection hashIdProcessors = pds.stream().filter(PropertyDescriptor::isIncludedInHashId).collect(Collectors.toList());
        String resultStr = null;
        if (!hashIdProcessors.isEmpty() || !this.directHashIdProcessors.isEmpty()) {
            ArrayList<HashCode> hashes = new ArrayList<HashCode>();
            for (PropertyDescriptor propertyDescriptor : hashIdProcessors) {
                P_Path0 path = propertyDescriptor.getPath();
                boolean isIriType = propertyDescriptor.isIriType();
                boolean excludeRdfProperty = propertyDescriptor.isExcludeRdfPropertyFromHashId();
                String iri = path.getNode().getURI();
                boolean isFwd = path.isForward();
                Function<? super Resource, ? extends Collection<? extends RDFNode>> propertyAccessor = propertyDescriptor.getRawProcessor();
                Collection<? extends RDFNode> col = propertyAccessor.apply((Resource)node);
                Class<?> colClass = col.getClass();
                boolean isOrdered = List.class.isAssignableFrom(colClass);
                ArrayList<HashCode> hashContribs = new ArrayList<HashCode>();
                for (RDFNode rDFNode : col) {
                    void var22_33;
                    boolean allowDescend;
                    Property p = ResourceFactory.createProperty((String)iri);
                    StatementImpl stmt = new StatementImpl(node, p, rDFNode);
                    Predicate<Statement> predicate = propertyDescriptor.getAllowDescendPredicate();
                    boolean bl = isIriType ? false : (allowDescend = predicate == null ? true : predicate.test((Statement)stmt));
                    if (!allowDescend && rDFNode.isURIResource()) {
                        String tmp = rDFNode.asResource().getURI();
                        Literal literal = rDFNode.getModel().createLiteral(tmp);
                    }
                    logger.debug("Gathering hashId contrib from " + this.clazz.getCanonicalName() + "." + String.valueOf(path) + " from " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)node)) + " to " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)var22_33)));
                    HashCode partialHashContrib = cxt.getGlobalProcessor().apply((RDFNode)var22_33, cxt);
                    if (partialHashContrib == null) {
                        Resource castItem = (Resource)JenaPluginUtils.polymorphicCast((RDFNode)var22_33);
                        partialHashContrib = cxt.getGlobalProcessor().apply((RDFNode)castItem, cxt);
                        if (partialHashContrib == null) {
                            throw new NullPointerException("Failed to gather hashId contrib from " + this.clazz.getCanonicalName() + "." + String.valueOf(path) + " from " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)node)) + " to " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)var22_33)));
                        }
                    }
                    HashCode fullHashContrib = excludeRdfProperty ? partialHashContrib : hashFn.newHasher().putString((CharSequence)iri, StandardCharsets.UTF_8).putBoolean(isFwd).putBytes(partialHashContrib.asBytes()).hash();
                    hashContribs.add(fullHashContrib);
                }
                HashCode propertyHash = hashContribs.isEmpty() ? hashFn.hashInt(0) : (isOrdered ? Hashing.combineOrdered(hashContribs) : Hashing.combineUnordered(hashContribs));
                hashes.add(propertyHash);
            }
            for (BiFunction biFunction : this.directHashIdProcessors) {
                HashCode contrib = (HashCode)biFunction.apply(node, cxt);
                hashes.add(contrib);
            }
            if (hashes.isEmpty()) {
                throw new RuntimeException("Could not obtain ID hashes for " + this.clazz.getCanonicalName() + " with node " + String.valueOf(node));
            }
            result = Hashing.combineUnordered(hashes);
            cxt.putHashId((RDFNode)node, result);
            for (BiFunction biFunction : this.directStringIdProcessors) {
                resultStr = (String)biFunction.apply(node, cxt);
                cxt.putStringId((RDFNode)node, resultStr);
            }
        } else {
            result = null;
            if (cxt.getHashId((RDFNode)node) == null) {
                cxt.putHashId((RDFNode)node, null);
            }
        }
        for (PropertyDescriptor pd : hashIdProcessors) {
            RDFList list;
            Collection<? extends RDFNode> col;
            Class<?> colClass;
            boolean isJavaList;
            P_Path0 p_Path0 = pd.getPath();
            String iri = p_Path0.getNode().getURI();
            Property p = ResourceFactory.createProperty((String)iri);
            boolean isFwd = p_Path0.isForward();
            Function<? super Resource, ? extends Collection<? extends RDFNode>> propertyAccessor = pd.getRawProcessor();
            RDFNode val = ResourceUtils.getPropertyValue((Resource)node, (Property)p, (boolean)isFwd, RDFNode.class);
            if (val == null || !(isJavaList = List.class.isAssignableFrom(colClass = (col = propertyAccessor.apply((Resource)node)).getClass())) || !val.canAs(RDFList.class)) continue;
            RDFList currentEntry = list = (RDFList)val.as(RDFList.class);
            int index = 0;
            while (!currentEntry.isEmpty()) {
                HashCode hashCode = hashFn.hashInt(index);
                RDFNode item = currentEntry.getHead();
                HashCode itemHash = cxt.getHashId(item);
                if (itemHash != null) {
                    HashCode entryHash = Hashing.combineOrdered(Arrays.asList(result, hashCode, itemHash));
                    cxt.putHashId((RDFNode)currentEntry, entryHash);
                    String entryStr = (String)(resultStr == null ? "" : resultStr + "_") + cxt.getHashAsString(entryHash);
                    cxt.putStringId((RDFNode)currentEntry, entryStr);
                }
                ++index;
                currentEntry = currentEntry.getTail();
            }
        }
        return result;
    }

    public void collectReachableResources(Resource node, HashIdCxt cxt) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            P_Path0 path = pd.getPath();
            if (pd.isIriType()) continue;
            Function<? super Resource, ? extends Collection<? extends RDFNode>> propertyAccessor = pd.getRawProcessor();
            Collection<? extends RDFNode> col = propertyAccessor.apply((Resource)node);
            for (RDFNode rDFNode : col) {
                try {
                    if (cxt.isPending(rDFNode)) continue;
                    logger.debug("Traversal " + this.clazz.getCanonicalName() + "." + String.valueOf(path) + " from " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)node)) + " to " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)rDFNode)));
                    MapperProxyUtils.collectReachableResources(rDFNode, cxt);
                }
                catch (IllegalStateException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

