/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.descriptor.impl;

import java.util.List;
import java.util.Set;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.reprogen.descriptor.impl.SimpleType;
import org.aksw.jenax.reprogen.descriptor.impl.TypeBase;
import org.aksw.jenax.reprogen.descriptor.impl.TypeCollection;

public class TypeCollectionImpl
extends TypeBase
implements TypeCollection {
    protected Class<?> collectionClass;
    protected SimpleType itemType;

    public TypeCollectionImpl(Class<?> collectionClass, SimpleType itemType) {
        this.collectionClass = collectionClass;
        this.itemType = itemType;
    }

    @Override
    public Class<?> getCollectionClass() {
        return this.collectionClass;
    }

    @Override
    public SimpleType getItemType() {
        return this.itemType;
    }

    @Override
    public SimpleType stricterType(SimpleType other) {
        TypeCollectionImpl result = null;
        if (other.isCollection()) {
            TypeCollection o = other.asCollection();
            Class<?> effectiveCollectionClass = MapperProxyUtils.getStricterType(this.collectionClass, o.getCollectionClass());
            SimpleType effectiveItemType = this.itemType.stricterType(o.getItemType());
            result = effectiveCollectionClass == null || effectiveItemType == null ? null : new TypeCollectionImpl(effectiveCollectionClass, effectiveItemType);
        }
        return result;
    }

    @Override
    public boolean isList() {
        boolean result = List.class.isAssignableFrom(this.collectionClass);
        return result;
    }

    @Override
    public boolean isSet() {
        boolean result = Set.class.isAssignableFrom(this.collectionClass);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectionClass == null ? 0 : this.collectionClass.hashCode());
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeCollectionImpl other = (TypeCollectionImpl)obj;
        if (this.collectionClass == null ? other.collectionClass != null : !this.collectionClass.equals(other.collectionClass)) {
            return false;
        }
        return !(this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType));
    }
}

