/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.core;

import java.lang.reflect.Method;
import java.util.Map;
import org.aksw.jenax.reprogen.core.MethodDescriptorCollection;
import org.aksw.jenax.reprogen.core.MethodDescriptorMap;
import org.aksw.jenax.reprogen.core.MethodDescriptorSimple;

public interface MethodDescriptor {
    public Method getMethod();

    public boolean isGetter();

    default public boolean isSetter() {
        return !this.isGetter();
    }

    public boolean isCollectionValued();

    public boolean isDynamicCollection();

    public Class<?> getType();

    public Class<?> getItemType();

    public Class<?> getCollectionType();

    public boolean isMapType();

    public Class<?> getKeyType();

    public Class<?> getValueType();

    public boolean isFluentCompatible();

    public static MethodDescriptor simpleGetter(Method method, Class<?> type) {
        return new MethodDescriptorSimple(method, true, false, type);
    }

    public static MethodDescriptor simpleSetter(Method method, boolean fluentCapable, Class<?> type) {
        return new MethodDescriptorSimple(method, false, fluentCapable, type);
    }

    public static MethodDescriptor collectionGetter(Method method, Class<?> collectionType, Class<?> itemType) {
        return new MethodDescriptorCollection(method, true, false, collectionType, itemType, false);
    }

    public static MethodDescriptor collectionSetter(Method method, boolean fluentCapable, Class<?> collectionType, Class<?> itemType) {
        return new MethodDescriptorCollection(method, false, fluentCapable, collectionType, itemType, false);
    }

    public static MethodDescriptor dynamicCollectionGetter(Method method, Class<?> collectionType, Class<?> boundedItemType) {
        return new MethodDescriptorCollection(method, true, false, collectionType, boundedItemType, true);
    }

    public static MethodDescriptor mapGetter(Method method, Map.Entry<Class<?>, Class<?>> mapTypes) {
        Class<?> keyType = mapTypes.getKey();
        Class<?> valueType = mapTypes.getValue();
        return new MethodDescriptorMap(method, true, false, keyType, valueType);
    }

    public static MethodDescriptor mapGetter(Method method, Class<?> keyType, Class<?> valueType) {
        return new MethodDescriptorMap(method, true, false, keyType, valueType);
    }

    public static MethodDescriptor mapSetter(Method method, boolean fluentCapable, Class<?> keyType, Class<?> valueType) {
        return new MethodDescriptorMap(method, false, fluentCapable, keyType, valueType);
    }
}

