/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.core;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Defaults;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.Proxy;
import org.aksw.commons.beans.datatype.DataType;
import org.aksw.commons.beans.datatype.DataTypes;
import org.aksw.commons.beans.datatype.MapType;
import org.aksw.commons.beans.datatype.TypeUtils;
import org.aksw.commons.beans.model.MethodHandleLookup;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.ConvertingList;
import org.aksw.commons.collections.ConvertingSet;
import org.aksw.commons.collections.MutableCollectionViews;
import org.aksw.commons.collections.maps.MapFromValueConverter;
import org.aksw.commons.collections.sets.SetFromCollection;
import org.aksw.commons.util.convert.ConvertFunction;
import org.aksw.commons.util.convert.ConvertFunctionImpl;
import org.aksw.jena_sparql_api.mapper.proxy.TypeDecider;
import org.aksw.jena_sparql_api.rdf.collections.ConverterFromNodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.ConverterFromNodeMapperAndModel;
import org.aksw.jena_sparql_api.rdf.collections.ConverterFromRDFNodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.ListFromRDFList;
import org.aksw.jena_sparql_api.rdf.collections.NodeConverter;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.NodeMappers;
import org.aksw.jena_sparql_api.rdf.collections.RDFNodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.RDFNodeMappers;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.rdf.collections.SetFromPropertyValues;
import org.aksw.jena_sparql_api.utils.views.map.MapFromKeyConverter;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResource;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResourceUnmanaged;
import org.aksw.jena_sparql_api.utils.views.map.MapVocab;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntry;
import org.aksw.jena_sparql_api.utils.views.map.RdfEntryWithCast;
import org.aksw.jenax.annotation.reprogen.HashId;
import org.aksw.jenax.annotation.reprogen.Inverse;
import org.aksw.jenax.annotation.reprogen.IriType;
import org.aksw.jenax.annotation.reprogen.KeyIri;
import org.aksw.jenax.annotation.reprogen.Namespace;
import org.aksw.jenax.annotation.reprogen.Namespaces;
import org.aksw.jenax.annotation.reprogen.PolymorphicOnly;
import org.aksw.jenax.annotation.reprogen.StringId;
import org.aksw.jenax.annotation.reprogen.ValueIri;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.reprogen.core.MethodDescriptor;
import org.aksw.jenax.reprogen.core.ResourceProxyBase;
import org.aksw.jenax.reprogen.core.ViewBundle;
import org.aksw.jenax.reprogen.hashid.ClassDescriptor;
import org.aksw.jenax.reprogen.hashid.HashIdCxt;
import org.aksw.jenax.reprogen.hashid.HashIdCxtImpl;
import org.aksw.jenax.reprogen.hashid.Metamodel;
import org.aksw.jenax.reprogen.shared.AnnotationUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.util.PrefixMapping2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperProxyUtils {
    private static final Logger logger = LoggerFactory.getLogger(MapperProxyUtils.class);
    private static LoadingCache<Class<?>, Optional<ClassDescriptor>> classDescriptorCache;

    public static Function<Class<?>, BiFunction<Property, Boolean, Function<Resource, ViewBundle>>> viewAsDynamicSet(Method m, boolean isIriType, boolean polymorphicOnly, TypeMapper typeMapper, TypeDecider typeDecider) {
        Function<Class, BiFunction> result = null;
        Class<?> baseItemType = MapperProxyUtils.canActAsCollectionView(m, Set.class, false, null);
        if (baseItemType != null) {
            result = clazz -> MapperProxyUtils.viewAsSet(m, isIriType, polymorphicOnly, clazz, typeMapper, typeDecider);
        }
        return result;
    }

    public static Function<Class<?>, BiFunction<Property, Boolean, Function<Resource, ViewBundle>>> viewAsDynamicList(Method m, boolean isIriType, boolean polymorphicOnly, TypeMapper typeMapper, TypeDecider typeDecider) {
        Function<Class, BiFunction> result = null;
        Class<?> baseItemType = MapperProxyUtils.canActAsCollectionView(m, List.class, true, null);
        if (baseItemType != null) {
            result = clazz -> MapperProxyUtils.viewAsList(m, isIriType, polymorphicOnly, clazz, typeMapper, typeDecider);
        }
        return result;
    }

    public static BiFunction<Property, Boolean, Function<Resource, ViewBundle>> viewAsSet(Method m, boolean isIriType, boolean polymorphicOnly, Class<?> itemType, TypeMapper typeMapper, TypeDecider typeDecider) {
        BiFunction<Property, Boolean, Function<Resource, ViewBundle>> result = null;
        if (String.class.isAssignableFrom(itemType) && isIriType) {
            result = (p, isFwd) -> s -> MapperProxyUtils.createViewBundleFromSetAndConverter(itemType, (Set<RDFNode>)new SetFromPropertyValues(s, p, isFwd.booleanValue(), RDFNode.class), new ConverterFromNodeMapperAndModel(s.getModel(), RDFNode.class, (Converter)new ConverterFromNodeMapper((NodeConverter)NodeMappers.uriString)), false);
        } else {
            RDFNodeMapper rdfNodeMapper = RDFNodeMappers.from(itemType, (TypeMapper)typeMapper, (TypeDecider)typeDecider, (boolean)polymorphicOnly, (boolean)false);
            result = (p, isFwd) -> s -> MapperProxyUtils.createViewBundleFromSetAndConverter(itemType, (Set<RDFNode>)new SetFromPropertyValues(s, p, isFwd.booleanValue(), RDFNode.class), new ConverterFromRDFNodeMapper((NodeConverter)rdfNodeMapper), false);
        }
        return result;
    }

    public static Function<Property, Function<Resource, ViewBundle>> viewAsMap(Method m, boolean isValueIriType, boolean polymorphicOnly, Class<?> keyType, Class<?> valueType, TypeMapper typeMapper, TypeDecider typeDecider) {
        Function<Property, Function<Resource, ViewBundle>> result = null;
        if (String.class.isAssignableFrom(valueType) && isValueIriType) {
            throw new RuntimeException("@IriType for maps not yet implemented yet");
        }
        Property keyProperty = Optional.ofNullable(m.getAnnotation(KeyIri.class)).map(x -> Strings.isNullOrEmpty((String)x.value()) ? MapVocab.key : ResourceFactory.createProperty((String)x.value())).orElse(MapVocab.key);
        Property valuePropertyTmp = Optional.ofNullable(m.getAnnotation(ValueIri.class)).map(x -> Strings.isNullOrEmpty((String)x.value()) ? MapVocab.value : ResourceFactory.createProperty((String)x.value())).orElse(null);
        Property valueProperty = valuePropertyTmp == null && !RDFNode.class.isAssignableFrom(valueType) ? MapVocab.value : valuePropertyTmp;
        result = p -> s -> MapperProxyUtils.createViewBundleFromMapAndConverter(s, p, keyProperty, valueProperty, keyType, valueType, typeMapper, typeDecider, polymorphicOnly);
        return result;
    }

    public static BiFunction<Property, Boolean, Function<Resource, ViewBundle>> viewAsList(Method m, boolean isIriType, boolean polymorphicOnly, Class<?> itemType, TypeMapper typeMapper, TypeDecider typeDecider) {
        BiFunction<Property, Boolean, Function<Resource, ViewBundle>> result = null;
        if (String.class.isAssignableFrom(itemType) && isIriType) {
            result = (p, isFwd) -> s -> MapperProxyUtils.createViewBundleFromListAndConverter(itemType, (List<RDFNode>)new ListFromRDFList(s, p), new ConverterFromNodeMapperAndModel(s.getModel(), RDFNode.class, (Converter)new ConverterFromNodeMapper((NodeConverter)NodeMappers.uriString)));
        } else {
            RDFNodeMapper rdfNodeMapper = RDFNodeMappers.from(itemType, (TypeMapper)typeMapper, (TypeDecider)typeDecider, (boolean)polymorphicOnly, (boolean)false);
            result = (p, isFwd) -> s -> MapperProxyUtils.createViewBundleFromListAndConverter(itemType, (List<RDFNode>)new ListFromRDFList(s, p), new ConverterFromRDFNodeMapper((NodeConverter)rdfNodeMapper));
        }
        return result;
    }

    public static ViewBundle createViewBundleFromListAndConverter(Class<?> itemType, List<RDFNode> list, Converter<RDFNode, ?> converter) {
        List rawView = MutableCollectionViews.filteringList(list, converter);
        ConvertingList javaView = new ConvertingList(rawView, converter);
        boolean isRdfItems = RDFNode.class.isAssignableFrom(itemType);
        if (isRdfItems) {
            rawView = javaView;
        }
        return new ViewBundle(rawView, javaView);
    }

    public static ViewBundle createViewBundleFromMapAndConverter(Resource s, Property p, Property keyProperty, Property valueProperty, Class<?> keyType, Class<?> valueType, TypeMapper typeMapper, TypeDecider typeDecider, boolean polymorphicOnly) {
        MapFromValueConverter javaMap;
        Set rdfEntrySet;
        Function<RDFNode, RDFNode> valueCastFunction;
        RDFNodeMapper keyMapper = RDFNodeMappers.from(keyType, (TypeMapper)typeMapper, (TypeDecider)typeDecider, (boolean)polymorphicOnly, (boolean)false);
        ConverterFromRDFNodeMapper keyConverter = new ConverterFromRDFNodeMapper((NodeConverter)keyMapper);
        ConvertFunction keyCastFunction = RDFNode.class.isAssignableFrom(keyType) ? ConvertFunctionImpl.create(RDFNode.class, keyType, rdfNode -> (RDFNode)keyMapper.toJava(rdfNode)) : ConvertFunctionImpl.create(RDFNode.class, RDFNode.class, x -> x);
        RDFNodeMapper valueMapper = RDFNodeMappers.from(valueType, (TypeMapper)typeMapper, (TypeDecider)typeDecider, (boolean)polymorphicOnly, (boolean)false);
        ConverterFromRDFNodeMapper valueConverter = new ConverterFromRDFNodeMapper((NodeConverter)valueMapper);
        Function<RDFNode, RDFNode> function = valueCastFunction = RDFNode.class.isAssignableFrom(valueType) ? rdfNode -> (RDFNode)valueMapper.toJava(rdfNode) : rdfNode -> rdfNode;
        if (valueProperty == null) {
            MapFromResourceUnmanaged rdfMap = new MapFromResourceUnmanaged(s, p, keyProperty, ConvertFunctionImpl.create(RDFNode.class, keyType, k -> (RDFNode)keyCastFunction.convert(k)), ConvertFunctionImpl.create(Resource.class, valueType, v -> (Resource)valueCastFunction.apply((RDFNode)v)));
            rdfEntrySet = rdfMap.entrySet();
            Converter vc = Converter.from(arg_0 -> MapperProxyUtils.lambda$createViewBundleFromMapAndConverter$25((Converter)valueConverter, arg_0), arg_0 -> MapperProxyUtils.lambda$createViewBundleFromMapAndConverter$26((Converter)valueConverter, arg_0));
            javaMap = new MapFromValueConverter((Map)new MapFromKeyConverter((Map)rdfMap, (Converter)keyConverter), vc);
        } else {
            MapFromResource rdfMap = new MapFromResource(s, p, keyProperty, valueProperty, ConvertFunctionImpl.create(RDFNode.class, keyType, k -> (RDFNode)keyCastFunction.convert(k)), ConvertFunctionImpl.create(RDFNode.class, valueType, v -> (RDFNode)valueCastFunction.apply((RDFNode)v)));
            rdfEntrySet = rdfMap.entrySet();
            javaMap = new MapFromValueConverter((Map)new MapFromKeyConverter((Map)rdfMap, (Converter)keyConverter), (Converter)valueConverter);
        }
        return new ViewBundle(rdfEntrySet, javaMap);
    }

    public static ViewBundle createViewBundleFromSetAndConverter(Class<?> itemType, Set<RDFNode> set, Converter<RDFNode, ?> converter, boolean isInjectiveConversion) {
        boolean isRdfItems = RDFNode.class.isAssignableFrom(itemType);
        Set rawView = MutableCollectionViews.filteringSet(set, converter);
        boolean debug = false;
        if (debug) {
            for (RDFNode rdfNode : rawView) {
                System.err.println(rdfNode);
            }
        }
        Object javaView = isInjectiveConversion ? new ConvertingSet(rawView, converter) : new SetFromCollection((Collection)new ConvertingCollection((Collection)rawView, converter));
        if (isRdfItems) {
            rawView = javaView;
        }
        return new ViewBundle(rawView, javaView);
    }

    public static MethodDescriptor classifyMethod(Method m) {
        MethodDescriptor result = null;
        result = (MethodDescriptor)ObjectUtils.firstNonNull((Object[])new MethodDescriptor[]{MapperProxyUtils.tryClassifyAsMapGetter(m), MapperProxyUtils.tryClassifyAsDynamicCollectionGetter(m), MapperProxyUtils.tryClassifyAsCollectionGetter(m), MapperProxyUtils.tryClassifyAsCollectionSetter(m), MapperProxyUtils.tryClassifyAsScalarGetter(m), MapperProxyUtils.tryClassifyAsScalarSetter(m)});
        return result;
    }

    public static MethodDescriptor tryClassifyAsScalarGetter(Method m) {
        Class<?> returnType = m.getReturnType();
        int paramCount = m.getParameterCount();
        MethodDescriptor result = paramCount == 0 && !Iterable.class.isAssignableFrom(returnType) ? MethodDescriptor.simpleGetter(m, returnType) : null;
        return result;
    }

    public static MethodDescriptor tryClassifyAsScalarSetter(Method m) {
        Class<?> paramType;
        MethodDescriptor result = null;
        Class<?> clazz = m.getDeclaringClass();
        Class<?> returnType = m.getReturnType();
        int paramCount = m.getParameterCount();
        if (paramCount == 1 && !Iterable.class.isAssignableFrom(paramType = m.getParameterTypes()[0])) {
            boolean isFluentCompatible = returnType.isAssignableFrom(clazz);
            result = MethodDescriptor.simpleSetter(m, isFluentCompatible, paramType);
        }
        return result;
    }

    public static MethodDescriptor tryClassifyAsCollectionSetter(Method m) {
        Class<?> paramType;
        MethodDescriptor result = null;
        Class<?> clazz = m.getDeclaringClass();
        Class<?> returnType = m.getReturnType();
        int paramCount = m.getParameterCount();
        if (paramCount == 1 && Iterable.class.isAssignableFrom(paramType = m.getParameterTypes()[0])) {
            Class itemType = TypeUtils.extractItemType((Type)m.getParameters()[0].getParameterizedType());
            boolean isFluentCompatible = returnType.isAssignableFrom(clazz);
            result = MethodDescriptor.collectionSetter(m, isFluentCompatible, paramType, itemType);
        }
        return result;
    }

    public static MethodDescriptor tryClassifyAsMapGetter(Method m) {
        Map.Entry mapTypes;
        MethodDescriptor result = null;
        Class<?> returnType = m.getReturnType();
        int paramCount = m.getParameterCount();
        if (paramCount == 0 && Map.class.isAssignableFrom(returnType) && (mapTypes = TypeUtils.extractMapTypes((Type)m.getGenericReturnType())) != null) {
            result = MethodDescriptor.mapGetter(m, mapTypes);
        }
        return result;
    }

    public static MethodDescriptor tryClassifyAsCollectionGetter(Method m) {
        Class itemType;
        MethodDescriptor result = null;
        Class<?> returnType = m.getReturnType();
        int paramCount = m.getParameterCount();
        if (paramCount == 0 && Iterable.class.isAssignableFrom(returnType) && (itemType = TypeUtils.extractItemType((Type)m.getGenericReturnType())) != null) {
            result = MethodDescriptor.collectionGetter(m, returnType, itemType);
        }
        return result;
    }

    public static BiFunction<Property, Boolean, Function<Resource, ViewBundle>> viewAsScalarGetter(MethodDescriptor methodDescriptor, Class<?> effectiveType, boolean isIriType, boolean polymorphicOnly, TypeMapper typeMapper, TypeDecider typeDecider) {
        BiFunction<Property, Boolean, Function> result = null;
        if (methodDescriptor.isGetter()) {
            BiFunction<Property, Boolean, Function<Resource, ViewBundle>> setView = MapperProxyUtils.viewAsSet(methodDescriptor.getMethod(), isIriType, polymorphicOnly, effectiveType, typeMapper, typeDecider);
            result = (p, isFwd) -> s -> {
                ViewBundle viewBundle = (ViewBundle)((Function)setView.apply((Property)p, (Boolean)isFwd)).apply(s);
                Set set = (Set)viewBundle.getJavaView();
                Iterator it = set.iterator();
                Object r = it.hasNext() ? it.next() : null;
                return new ViewBundle(viewBundle.getRawView(), r);
            };
        }
        return result;
    }

    public static BiFunction<Property, Boolean, Function<Resource, Object>> viewAsScalarGetterOldAndUnused(MethodDescriptor methodDescriptor, Class<?> effectiveType, boolean isIriType, TypeMapper typeMapper, TypeDecider typeDecider) {
        BiFunction<Property, Boolean, Function> result = null;
        if (methodDescriptor.isGetter()) {
            if (RDFNode.class.isAssignableFrom(effectiveType)) {
                Class<?> rdfType = effectiveType;
                result = (p, isFwd) -> s -> ResourceUtils.getPropertyValue((Resource)s, (Property)p, (boolean)isFwd, (Class)rdfType);
            } else if (isIriType) {
                if (!String.class.isAssignableFrom(effectiveType)) {
                    throw new RuntimeException("@IriType annotation requires String type");
                }
                result = (p, isFwd) -> s -> ResourceUtils.getPropertyValue((Resource)s, (Property)p, (boolean)isFwd, (NodeMapper)NodeMappers.uriString);
            } else {
                Object defaultValue = effectiveType.isPrimitive() ? Defaults.defaultValue(effectiveType) : null;
                RDFDatatype dtype = typeMapper.getTypeByClass(effectiveType);
                if (dtype != null) {
                    result = (p, isFwd) -> s -> {
                        Object r = ResourceUtils.getLiteralPropertyValue((Resource)s, (Property)p, (Class)effectiveType);
                        if (r == null) {
                            r = defaultValue;
                        }
                        return r;
                    };
                }
            }
        }
        return result;
    }

    public static boolean matchesCollectionViewSetter(Method m) {
        return false;
    }

    public static boolean matchesDynamicCollectionViewGetter(Method m, Class<?> expectedReturnType, boolean expectSubClassOfIterable, Class<?> expectedArgType) {
        Class<?> pt;
        Class<?>[] pts;
        boolean isCollectionTypeMatch;
        boolean result = false;
        Class<?> actualReturnType = m.getReturnType();
        boolean bl = isCollectionTypeMatch = expectSubClassOfIterable ? expectedReturnType.isAssignableFrom(actualReturnType) : actualReturnType.isAssignableFrom(expectedReturnType);
        if (isCollectionTypeMatch && (pts = m.getParameterTypes()).length == 1 && (pt = pts[0]).isAssignableFrom(expectedArgType)) {
            result = true;
        }
        return result;
    }

    public static MethodDescriptor tryClassifyAsDynamicCollectionGetter(Method m) {
        Class<?> boundedType = MapperProxyUtils.canActAsCollectionView(m, Iterable.class, true, null);
        MethodDescriptor result = boundedType == null ? null : MethodDescriptor.dynamicCollectionGetter(m, m.getReturnType(), boundedType);
        return result;
    }

    public static Class<?> canActAsCollectionView(Method m, Class<?> iterableClass, boolean expectSubClassOfIterable, Class<?> typeVariableBound) {
        TypeVariable<Method>[] tps;
        Class result = null;
        boolean isRawMatch = MapperProxyUtils.matchesDynamicCollectionViewGetter(m, iterableClass, expectSubClassOfIterable, Class.class);
        if (isRawMatch && (tps = m.getTypeParameters()).length == 1) {
            TypeVariable<Method> tv = tps[0];
            Type[] bounds = tv.getBounds();
            Object bound = null;
            switch (bounds.length) {
                case 0: {
                    bound = Object.class;
                    break;
                }
                case 1: {
                    bound = bounds[0];
                    break;
                }
                default: {
                    logger.debug("Candidate collection view rejected, because exactly 1 bound expected, got: " + bounds.length + " " + String.valueOf(Arrays.asList(bounds)) + "; " + String.valueOf(m));
                }
            }
            if (bound != null && bound instanceof Class) {
                boolean isCompatibleBound;
                Class boundClass = (Class)bound;
                boolean bl = isCompatibleBound = typeVariableBound == null || typeVariableBound.isAssignableFrom(boundClass);
                if (isCompatibleBound) {
                    result = boundClass;
                    logger.debug("Candidate collection view accepted; detected item type " + String.valueOf(result) + "; " + String.valueOf(m));
                } else {
                    logger.debug("Candidate collection view rejected, because bound class " + String.valueOf(boundClass) + " does not satisfy compatibility with " + String.valueOf(typeVariableBound));
                }
            } else {
                logger.debug("Candidate collection view rejected, because bound is a type but not a class " + String.valueOf(bound) + "; " + String.valueOf(m));
            }
        }
        return result;
    }

    public static Function<Property, BiConsumer<Resource, Object>> viewAsCollectionView(Method m, TypeMapper typeMapper) {
        return null;
    }

    public static Object applyInModelIfApplicable(Object o, Model sourceModel) {
        Object result;
        if (o instanceof RDFNode) {
            RDFNode rdfNode = (RDFNode)o;
            result = rdfNode.inModel(sourceModel);
        } else {
            result = o;
        }
        return result;
    }

    public static BiFunction<Property, Boolean, BiConsumer<Resource, Object>> viewAsScalarSetter(MethodDescriptor methodDescriptor, Class<?> effectiveType, boolean isIriType, boolean polymorphicOnly, TypeMapper typeMapper, TypeDecider typeDecider) {
        BiFunction<Property, Boolean, Function<Resource, ViewBundle>> setView = MapperProxyUtils.viewAsSet(methodDescriptor.getMethod(), isIriType, polymorphicOnly, effectiveType, typeMapper, typeDecider);
        BiFunction<Property, Boolean, BiConsumer<Resource, Object>> result = (p, isFwd) -> (s, o) -> {
            ViewBundle viewBundle = (ViewBundle)((Function)setView.apply((Property)p, (Boolean)isFwd)).apply(s);
            o = MapperProxyUtils.applyInModelIfApplicable(o, s.getModel());
            Set set = (Set)viewBundle.getJavaView();
            set.clear();
            set.add(o);
        };
        return result;
    }

    public static Class<?> getStricterType(Class<?> a, Class<?> b) {
        Class<Object> result = a != null && b != null ? (a.isAssignableFrom(b) ? b : (b.isAssignableFrom(a) ? a : null)) : (Class<Object>)ObjectUtils.firstNonNull((Object[])new Class[]{a, b});
        return result;
    }

    public static <T> T niceInvoke(Method method, Object target, Object ... args) {
        Object result;
        try {
            Object tmp;
            result = tmp = method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static PrefixMapping readPrefixesFromClass(Class<?> cls, PrefixMapping out) {
        Namespace ns;
        Objects.requireNonNull(cls);
        Objects.requireNonNull(out);
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null) {
            MapperProxyUtils.readPrefixesFromClass(superClass, out);
        }
        for (Class<?> i : cls.getInterfaces()) {
            MapperProxyUtils.readPrefixesFromClass(i, out);
        }
        Namespaces nss = cls.getAnnotation(Namespaces.class);
        if (nss != null && nss.value() != null) {
            for (Namespace ns2 : nss.value()) {
                MapperProxyUtils.addPrefix(cls, out, ns2.prefix(), ns2.value());
            }
        }
        if ((ns = cls.getAnnotation(Namespace.class)) != null) {
            MapperProxyUtils.addPrefix(cls, out, ns.prefix(), ns.value());
        }
        return out;
    }

    public static void addPrefix(Class<?> cls, PrefixMapping out, String prefix, String value) {
        logger.debug("Derived prefix " + prefix + " -> " + value + " from annotation on " + cls.getCanonicalName());
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(value);
        out.setNsPrefix(prefix, value);
    }

    public static <T extends Resource> BiFunction<Node, EnhGraph, T> createProxyFactory(Class<T> clazz, PrefixMapping basePm, TypeDecider typeDecider) {
        BiFunction<Node, EnhGraph, Resource> result;
        Method[] methods;
        boolean hasClassHashId;
        PrefixMapping2 pm = new PrefixMapping2(basePm);
        MapperProxyUtils.readPrefixesFromClass(clazz, (PrefixMapping)pm);
        Metamodel metamodel = Metamodel.get();
        ClassDescriptor classDescriptor = metamodel.getOrCreate(clazz);
        boolean bl = hasClassHashId = clazz.getAnnotation(HashId.class) != null;
        if (hasClassHashId) {
            classDescriptor.registerDirectHashIdProcessor((r, cxt) -> cxt.getHashFunction().hashString((CharSequence)clazz.getCanonicalName(), StandardCharsets.UTF_8));
        }
        String prefix = MapperProxyUtils.classToTag(clazz);
        BiFunction<Resource, HashIdCxt, String> directStringIdProcessor = null;
        final LinkedHashMap<Method, BiFunction<Object, Object[], Object>> methodImplMap = new LinkedHashMap<Method, BiFunction<Object, Object[], Object>>();
        TypeMapper typeMapper = TypeMapper.getInstance();
        Map paths = AnnotationUtils.indexPathsByBeanPropertyName(clazz, (PrefixMapping)pm);
        LinkedHashMap<String, Method> readMethods = new LinkedHashMap<String, Method>();
        LinkedHashMap<String, Method> writeMethods = new LinkedHashMap<String, Method>();
        Sets.SetView beanPropertyNames = Sets.union(readMethods.keySet(), writeMethods.keySet());
        HashMap<Method, MethodDescriptor> methodDescriptors = new HashMap<Method, MethodDescriptor>();
        for (Method method2 : methods = clazz.getMethods()) {
            MethodDescriptor descriptor;
            if (method2.isDefault()) {
                BiFunction<Object, Object[], Object> defaultMethodDelegate;
                try {
                    defaultMethodDelegate = MapperProxyUtils.proxyDefaultMethod(method2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                methodImplMap.put(method2, defaultMethodDelegate);
            }
            if ((descriptor = MapperProxyUtils.classifyMethod(method2)) == null || method2.isBridge()) continue;
            String beanPropertyName = AnnotationUtils.deriveBeanPropertyName((String)method2.getName());
            methodDescriptors.put(method2, descriptor);
            if (descriptor.isGetter()) {
                readMethods.put(beanPropertyName, method2);
            } else if (descriptor.isSetter()) {
                writeMethods.put(beanPropertyName, method2);
            }
            List ps = AnnotationUtils.derivePathsFromMethod((Method)method2, (PrefixMapping)pm);
            for (P_Path0 path : ps) {
                paths.put(beanPropertyName, path);
            }
        }
        Method toStringMethod = null;
        try {
            toStringMethod = ResourceImpl.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            logger.warn("Method " + clazz.getName() + ".toString() not found");
        }
        methodImplMap.put(toStringMethod, MapperProxyUtils::defaultToString);
        for (String beanPropertyName : beanPropertyNames) {
            BiFunction<Property, Boolean, BiConsumer<Resource, Object>> setter;
            MapType targetDataType;
            P_Path0 effectivePath;
            Method readMethod = (Method)readMethods.get(beanPropertyName);
            MethodDescriptor readMethodDescriptor = (MethodDescriptor)methodDescriptors.get(readMethod);
            Method writeMethod = (Method)writeMethods.get(beanPropertyName);
            MethodDescriptor writeMethodDescriptor = (MethodDescriptor)methodDescriptors.get(writeMethod);
            Class<?> readType = null;
            Class<?> readCollectionType = null;
            Class<?> readItemType = null;
            boolean isReadIriType = false;
            boolean isReadPolymorphicOnly = false;
            boolean isReadInverse = false;
            boolean isReadHashId = false;
            boolean isReadStringId = false;
            boolean isReadHashIdWithoutProperty = false;
            Class<?> writeType = null;
            Class<?> writeCollectionType = null;
            Class<?> writeItemType = null;
            boolean isWriteIriType = false;
            boolean isWritePolymorphicOnly = false;
            boolean isWriteInverse = false;
            boolean isWriteHashId = false;
            boolean isWriteStringId = false;
            boolean isWriteHashIdWithoutProperty = false;
            if (readMethodDescriptor != null) {
                readType = readMethodDescriptor.getType();
                readCollectionType = readMethodDescriptor.getCollectionType();
                readItemType = readMethodDescriptor.getItemType();
                isReadIriType = readMethod.getAnnotation(IriType.class) != null;
                isReadPolymorphicOnly = readMethod.getAnnotation(PolymorphicOnly.class) != null;
                isReadInverse = readMethod.getAnnotation(Inverse.class) != null;
                HashId readHashId = readMethod.getAnnotation(HashId.class);
                isReadHashId = readHashId != null;
                isReadHashIdWithoutProperty = isReadHashId && readHashId.excludeRdfProperty();
                boolean bl2 = isReadStringId = readMethod.getAnnotation(StringId.class) != null;
            }
            if (writeMethodDescriptor != null) {
                writeType = writeMethodDescriptor.getType();
                writeCollectionType = writeMethodDescriptor.getCollectionType();
                writeItemType = writeMethodDescriptor.getItemType();
                isWriteIriType = writeMethod.getAnnotation(IriType.class) != null;
                isWritePolymorphicOnly = writeMethod.getAnnotation(PolymorphicOnly.class) != null;
                isWriteInverse = writeMethod.getAnnotation(Inverse.class) != null;
                HashId writeHashId = writeMethod.getAnnotation(HashId.class);
                isWriteHashId = writeHashId != null;
                isWriteHashIdWithoutProperty = isWriteHashId && writeHashId.excludeRdfProperty();
                isWriteStringId = writeMethod.getAnnotation(StringId.class) != null;
            }
            Class<?> effectiveType = MapperProxyUtils.getStricterType(readType, writeType);
            Class<Set> effectiveCollectionType = MapperProxyUtils.getStricterType(readCollectionType, writeCollectionType);
            Class<?> effectiveItemType = MapperProxyUtils.getStricterType(readItemType, writeItemType);
            boolean isIriType = isReadIriType || isWriteIriType;
            boolean polymorphicOnly = isReadPolymorphicOnly || isWritePolymorphicOnly;
            boolean isInverse = isReadInverse || isWriteInverse;
            boolean isHashId = isReadHashId || isWriteHashId;
            boolean isHashIdWithoutProperty = isReadHashIdWithoutProperty || isWriteHashIdWithoutProperty;
            boolean isStringId = isReadStringId || isWriteStringId;
            boolean isFwd = !isInverse;
            P_Path0 path = (P_Path0)paths.get(beanPropertyName);
            Object object = isFwd ? path : (effectivePath = path.isForward() ? new P_ReverseLink(path.getNode()) : new P_Link(path.getNode()));
            if (path == null) {
                Class<?> returnType;
                BiFunction<Resource, HashIdCxt, Object> fn;
                if (isHashId) {
                    fn = null;
                    if (writeMethod != null) {
                        returnType = writeMethod.getReturnType();
                        if (HashCode.class.isAssignableFrom(returnType) && HashIdCxt.class.equals(effectiveType)) {
                            logger.debug("  Found direct hash method: " + String.valueOf(writeMethod));
                            fn = (s, cxt) -> (HashCode)MapperProxyUtils.niceInvoke(writeMethod, s, cxt);
                        }
                    } else if (readMethod != null) {
                        logger.debug("  Found direct hash method: " + String.valueOf(readMethod));
                        fn = (s, cxt) -> (HashCode)MapperProxyUtils.niceInvoke(readMethod, s, new Object[0]);
                    }
                    if (fn == null) {
                        throw new RuntimeException("HashId annotation found, but method signature does not match. Candidates: " + String.valueOf(writeMethod) + " " + String.valueOf(readMethod));
                    }
                    classDescriptor.registerDirectHashIdProcessor(fn);
                }
                if (!isStringId) continue;
                if (directStringIdProcessor != null) {
                    throw new RuntimeException("String id processor already registered for " + String.valueOf(clazz));
                }
                fn = null;
                if (writeMethod != null) {
                    returnType = writeMethod.getReturnType();
                    if (String.class.isAssignableFrom(returnType) && HashIdCxt.class.equals(effectiveType)) {
                        logger.debug("  Found direct stringId method: " + String.valueOf(writeMethod));
                        fn = (s, cxt) -> (String)MapperProxyUtils.niceInvoke(writeMethod, s, cxt);
                    }
                } else if (readMethod != null) {
                    logger.debug("  Found direct string method: " + String.valueOf(readMethod));
                    fn = (s, cxt) -> (String)MapperProxyUtils.niceInvoke(readMethod, s, new Object[0]);
                }
                if (fn == null) {
                    throw new RuntimeException("HashId annotation found, but method signature does not match. Candidates: " + String.valueOf(writeMethod) + " " + String.valueOf(readMethod));
                }
                directStringIdProcessor = fn;
                continue;
            }
            Property p = ResourceFactory.createProperty((String)path.getNode().getURI());
            if (readMethod == null) continue;
            boolean isCollectionValued = readMethodDescriptor.isCollectionValued();
            boolean isDynamicGetter = readMethodDescriptor.isDynamicCollection();
            boolean isMapValued = readMethodDescriptor.isMapType();
            if (isCollectionValued) {
                BiFunction<Property, Boolean, Function<Resource, ViewBundle>> collectionView;
                if (writeMethod != null) {
                    boolean isWriteMethodCollectionValued = writeMethodDescriptor.isCollectionValued();
                    if (isCollectionValued != isWriteMethodCollectionValued) {
                        throw new RuntimeException("Invalid type combination: collection and non-collection valued");
                    }
                    if (effectiveCollectionType == null) {
                        throw new RuntimeException("Incompatible collection types: " + String.valueOf(readCollectionType) + " vs " + String.valueOf(writeCollectionType) + " on " + String.valueOf(readMethod) + " and " + String.valueOf(writeMethod));
                    }
                }
                boolean isListType = List.class.isAssignableFrom(effectiveCollectionType);
                boolean isSetType = Set.class.isAssignableFrom(effectiveCollectionType) || effectiveCollectionType.isAssignableFrom(Set.class) && !isListType;
                targetDataType = DataTypes.newCollectionType(effectiveCollectionType, effectiveItemType);
                if (isDynamicGetter) {
                    Function<Class<?>, BiFunction<Property, Boolean, Function<Resource, ViewBundle>>> collectionGetter;
                    if (isSetType) {
                        collectionGetter = MapperProxyUtils.viewAsDynamicSet(readMethod, isIriType, polymorphicOnly, typeMapper, typeDecider);
                    } else if (isListType) {
                        collectionGetter = MapperProxyUtils.viewAsDynamicList(readMethod, isIriType, polymorphicOnly, typeMapper, typeDecider);
                    } else {
                        throw new RuntimeException("todo dynamic collection support implement");
                    }
                    if (collectionGetter == null) continue;
                    BiFunction<Object, Object[], Object> biFunction = (o, args) -> {
                        Class clz = Objects.requireNonNull((Class)args[0]);
                        BiFunction ps = (BiFunction)collectionGetter.apply(clz);
                        Function s = (Function)ps.apply(p, isFwd);
                        ViewBundle v = (ViewBundle)s.apply((Resource)o);
                        Object r = v.getJavaView();
                        return r;
                    };
                    methodImplMap.put(readMethod, biFunction);
                    classDescriptor.getOrCreatePropertyDescriptor(effectivePath).setIncludedInHashId(isHashId).setRdfPropertyExcludedFromHashId(isHashIdWithoutProperty).setTargetType((DataType)targetDataType).setIriType(isIriType).setRawProcessor(s -> {
                        BiFunction ps = (BiFunction)collectionGetter.apply(effectiveItemType);
                        Function sx = (Function)ps.apply(p, isFwd);
                        ViewBundle v = (ViewBundle)sx.apply(s);
                        Collection<RDFNode> r = v.getRawView();
                        return r;
                    });
                    continue;
                }
                if (isListType) {
                    collectionView = MapperProxyUtils.viewAsList(readMethod, isIriType, polymorphicOnly, effectiveItemType, typeMapper, typeDecider);
                } else if (isSetType) {
                    collectionView = MapperProxyUtils.viewAsSet(readMethod, isIriType, polymorphicOnly, effectiveItemType, typeMapper, typeDecider);
                } else {
                    throw new RuntimeException("Unsupported collection type");
                }
                Function<Resource, ViewBundle> raw = collectionView.apply(p, isFwd);
                BiFunction<Object, Object[], Object> biFunction = (s, args) -> ((ViewBundle)raw.apply((Resource)s)).getJavaView();
                methodImplMap.put(readMethod, biFunction);
                classDescriptor.getOrCreatePropertyDescriptor(effectivePath).setTargetType((DataType)targetDataType).setIncludedInHashId(isHashId).setRdfPropertyExcludedFromHashId(isHashIdWithoutProperty).setIriType(isIriType).setRawProcessor(s -> {
                    ViewBundle vb = (ViewBundle)raw.apply((Resource)s);
                    Collection<RDFNode> col = vb.getRawView();
                    return col;
                });
                if (writeMethod == null) continue;
                if (isListType || isSetType) {
                    boolean returnThis = writeMethodDescriptor.isFluentCompatible();
                    methodImplMap.put(writeMethod, (obj, args) -> {
                        Object collectionViewObj = readImpl.apply(obj, new Object[0]);
                        Collection collection = (Collection)collectionViewObj;
                        ArrayList copy = Lists.newArrayList((Iterable)((Iterable)args[0]));
                        collection.clear();
                        collection.addAll(copy);
                        Object r = returnThis ? obj : null;
                        return r;
                    });
                    continue;
                }
                throw new RuntimeException("todo implement");
            }
            if (isMapValued) {
                Class<?> keyType = readMethodDescriptor.getKeyType();
                Class<?> valueType = readMethodDescriptor.getValueType();
                targetDataType = DataTypes.newMapType(keyType, valueType);
                Function<Property, Function<Resource, ViewBundle>> getter = MapperProxyUtils.viewAsMap(readMethod, isIriType, polymorphicOnly, keyType, valueType, typeMapper, typeDecider);
                Function<Resource, ViewBundle> g2 = getter.apply(p);
                methodImplMap.put(readMethod, (o, args) -> ((ViewBundle)g2.apply((Resource)o)).getJavaView());
                classDescriptor.getOrCreatePropertyDescriptor(effectivePath).setTargetType((DataType)targetDataType).setIncludedInHashId(isHashId).setRdfPropertyExcludedFromHashId(isHashIdWithoutProperty).setIriType(isIriType).setRawProcessor(s -> {
                    ViewBundle vb = (ViewBundle)g2.apply((Resource)s);
                    Collection<RDFNode> col = vb.getRawView();
                    return col;
                });
                continue;
            }
            if (effectiveType == null) {
                throw new RuntimeException("Incompatible types on getter / setter for property '" + beanPropertyName + "' on class " + String.valueOf(clazz));
            }
            DataType targetDataType2 = DataTypes.of(effectiveType);
            BiFunction<Property, Boolean, Function<Resource, ViewBundle>> getter = MapperProxyUtils.viewAsScalarGetter(readMethodDescriptor, effectiveType, isIriType, polymorphicOnly, typeMapper, typeDecider);
            if (getter != null) {
                Function<Resource, ViewBundle> g3 = getter.apply(p, isFwd);
                methodImplMap.put(readMethod, (o, args) -> ((ViewBundle)g3.apply((Resource)o)).getJavaView());
                classDescriptor.getOrCreatePropertyDescriptor(effectivePath).setTargetType(targetDataType2).setIncludedInHashId(isHashId).setRdfPropertyExcludedFromHashId(isHashIdWithoutProperty).setIriType(isIriType).setRawProcessor(s -> {
                    ViewBundle vb = (ViewBundle)g3.apply((Resource)s);
                    Collection<RDFNode> col = vb.getRawView();
                    return col;
                });
            }
            if (writeMethod == null || (setter = MapperProxyUtils.viewAsScalarSetter(writeMethodDescriptor, effectiveType, isIriType, polymorphicOnly, typeMapper, typeDecider)) == null) continue;
            BiConsumer<Resource, Object> s2 = setter.apply(p, isFwd);
            boolean returnThis = writeMethodDescriptor.isFluentCompatible();
            methodImplMap.put(writeMethod, (o, args) -> {
                s2.accept((Resource)o, args[0]);
                Object r = returnThis ? o : null;
                return r;
            });
        }
        if (directStringIdProcessor == null) {
            directStringIdProcessor = MapperProxyUtils.createDefaultStringIdProcessor(prefix);
        }
        classDescriptor.registerDirectStringIdProcessor(directStringIdProcessor);
        boolean useCgLib = false;
        boolean useByteBuddy = true;
        if (useCgLib) {
            Enhancer enhancer = new Enhancer();
            if (clazz.isInterface()) {
                enhancer.setSuperclass(ResourceProxyBase.class);
                enhancer.setInterfaces(new Class[]{clazz});
            } else {
                if (!Resource.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Failed to use " + String.valueOf(clazz) + " as a resource view because but it does not extend  " + String.valueOf(Resource.class));
                }
                enhancer.setSuperclass(clazz);
            }
            enhancer.setCallback((Callback)new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    Object r;
                    BiFunction delegate = (BiFunction)methodImplMap.get(method);
                    if (delegate != null) {
                        r = delegate.apply(obj, args);
                    } else {
                        if (method.isDefault()) {
                            throw new RuntimeException("Should never come here anymore");
                        }
                        r = proxy.invokeSuper(obj, args);
                    }
                    return r;
                }
            });
            result = (n, g) -> {
                Class[] argTypes = new Class[]{Node.class, EnhGraph.class};
                Object[] argValues = new Object[]{n, g};
                Class<MapperProxyUtils> clazz = MapperProxyUtils.class;
                synchronized (MapperProxyUtils.class) {
                    Object o = enhancer.create(argTypes, argValues);
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return (Resource)o;
                }
            };
        } else if (useByteBuddy) {
            DynamicType.Builder builder;
            ByteBuddy bb = new ByteBuddy();
            if (clazz.isInterface()) {
                builder = bb.subclass(ResourceProxyBase.class).implement(new Type[]{clazz});
            } else {
                if (!Resource.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Failed to use " + String.valueOf(clazz) + " as a resource view because but it does not extend  " + String.valueOf(Resource.class));
                }
                builder = bb.subclass(clazz);
            }
            for (Map.Entry entry : methodImplMap.entrySet()) {
                builder = builder.method((ElementMatcher)ElementMatchers.anyOf((Method[])new Method[]{(Method)entry.getKey()})).intercept((Implementation)InvocationHandlerAdapter.of((obj, method, args) -> {
                    Object r = ((BiFunction)e.getValue()).apply(obj, args);
                    return r;
                }));
            }
            Class clz = builder.make().load(clazz.getClassLoader()).getLoaded();
            result = (n, g) -> {
                Class<MapperProxyUtils> clazz = MapperProxyUtils.class;
                synchronized (MapperProxyUtils.class) {
                    Object o;
                    try {
                        Constructor ctor = clz.getConstructor(Node.class, EnhGraph.class);
                        o = ctor.newInstance(n, g);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return (Resource)o;
                }
            };
        } else {
            result = (n, g) -> {
                ResourceImpl base = new ResourceImpl(n, g);
                Class<?> baseClass = base.getClass();
                Resource obj = (Resource)Proxy.newProxyInstance((ClassLoader)clazz.getClassLoader(), (Class[])new Class[]{clazz}, (o, m, args) -> {
                    Object r;
                    args = args == null ? new Object[]{} : args;
                    Class[] argTypes = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        argTypes[i] = Optional.ofNullable(args[i]).map(Object::getClass).orElse(null);
                    }
                    String methodName = m.getName();
                    Method baseMethod = null;
                    try {
                        baseMethod = baseClass.getMethod(methodName, argTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (baseMethod != null) {
                        r = baseMethod.invoke((Object)base, args);
                    } else {
                        BiFunction delegate = (BiFunction)methodImplMap.get(m);
                        if (delegate != null) {
                            r = delegate.apply(base, args);
                        } else {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return r;
                });
                return obj;
            };
        }
        return result;
    }

    public static BiFunction<Resource, HashIdCxt, String> createDefaultStringIdProcessor(String prefix) {
        return (r, cxt) -> {
            HashCode hashCode = cxt.getHashId((RDFNode)r);
            String part = cxt.getHashAsString(hashCode);
            String rr = prefix + "-" + part;
            return rr;
        };
    }

    public static BiFunction<Object, Object[], Object> proxyDefaultMethod(Method method) throws ReflectiveOperationException {
        MethodHandle unboundHandle = MethodHandleLookup.getMethodHandleLookup().lookup(method);
        BiFunction<Object, Object[], Object> defaultMethodDelegate = (o, a) -> {
            Object r;
            MethodHandle boundHandle = unboundHandle.bindTo(o);
            try {
                r = boundHandle.invokeWithArguments(a);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return r;
        };
        return defaultMethodDelegate;
    }

    public static String defaultToString(Object that, Object[] args) {
        return MapperProxyUtils.toStringTree(that, args);
    }

    public static String toStringTree(Object that, Object[] args) {
        Resource res = (Resource)that;
        Object[] interfaces = res.getClass().getInterfaces();
        Model m = ModelFactory.createDefaultModel();
        Resource closure = res.inModel(ResourceUtils.bnodeClosure((Resource)res));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)baos, (Model)closure.getModel(), (RDFFormat)RDFFormat.TURTLE_PRETTY);
        String r = String.valueOf(res.asNode()) + " (javaInterfaces: " + Arrays.toString(interfaces) + "): [" + baos.toString() + "]";
        return r;
    }

    public static String toStringDirectProperties(Object that, Object[] args) {
        Resource res = (Resource)that;
        Model m = ModelFactory.createDefaultModel();
        m.add(res.listProperties());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)baos, (Model)m, (RDFFormat)RDFFormat.TURTLE_BLOCKS);
        String r = String.valueOf(res.asNode()) + ": [" + baos.toString() + "]";
        return r;
    }

    public static HashIdCxt getHashId(RDFNode root) {
        HashIdCxtImpl cxt = new HashIdCxtImpl(Hashing.sha256(), MapperProxyUtils::getHashIdCore);
        cxt.declarePending(root);
        MapperProxyUtils.getHashId(root, cxt);
        return cxt;
    }

    public static Resource skolemize(String iriPrefix, Resource root) {
        return MapperProxyUtils.skolemize(iriPrefix, root, null);
    }

    public static Resource skolemize(String iriPrefix, Resource root, Consumer<Map<RDFNode, String>> renamesCallback) {
        HashIdCxt hashIdCxt = MapperProxyUtils.getHashId((RDFNode)root);
        Map<RDFNode, String> renames = hashIdCxt.getStringIdMapping();
        if (renamesCallback != null) {
            renamesCallback.accept(renames);
        }
        Map map = ResourceUtils.renameResources((String)iriPrefix, renames);
        Resource result = (Resource)map.get(root);
        return result;
    }

    public static HashCode getHashId(RDFNode root, HashIdCxt cxt) {
        MapperProxyUtils.collectReachableResources(root, cxt);
        Set<RDFNode> pending = cxt.getPending();
        while (!pending.isEmpty()) {
            RDFNode start = pending.iterator().next();
            MapperProxyUtils.getHashIdCore(start, cxt);
        }
        HashCode result = cxt.getHashId(root);
        return result;
    }

    public static HashCode getHashIdCore(RDFNode root, HashIdCxt cxt) {
        Map<RDFNode, HashCode> mapping = cxt.getHashIdMapping();
        HashCode result = mapping.get(root);
        result = result != null ? mapping.get(root) : MapperProxyUtils.getHashIdActual(root, cxt);
        return result;
    }

    public static HashCode getHashIdActual(RDFNode root, HashIdCxt cxt) {
        HashCode result;
        if (root == null) {
            throw new NullPointerException();
        }
        cxt.declareProcessing(root);
        HashFunction hashFn = cxt.getHashFunction();
        if (root.isLiteral()) {
            Var n = root.isAnon() ? Vars.x : root.asNode();
            Literal l = root.asLiteral();
            Object o = l.getValue();
            if (o instanceof String) {
                String str = (String)o;
                result = hashFn.hashString((CharSequence)str, StandardCharsets.UTF_8);
            } else {
                result = hashFn.hashString((CharSequence)NodeFmtLib.strNT((Node)n), StandardCharsets.UTF_8);
            }
        } else {
            Class<?> rootClass = root.getClass();
            ClassDescriptor cd = MapperProxyUtils.getClassDescriptorCached(rootClass);
            if (cd != null) {
                result = cd.computeHashId((Resource)root, cxt);
            } else {
                result = null;
                logger.debug("No class descriptor found for node; may be undesired " + String.valueOf(ResourceUtils.asBasicRdfNode((RDFNode)root)) + " - " + String.valueOf(root));
            }
        }
        cxt.putHashId(root, result);
        return result;
    }

    public static void collectReachableResources(RDFNode root, HashIdCxt cxt) {
        if (root == null) {
            throw new NullPointerException();
        }
        cxt.declarePending(root);
        Class<?> rootClass = root.getClass();
        ClassDescriptor cd = MapperProxyUtils.getClassDescriptorCached(rootClass);
        if (cd != null) {
            cd.collectReachableResources((Resource)root, cxt);
        }
    }

    public static ClassDescriptor getClassDescriptorCached(Class<?> clazz) {
        ClassDescriptor result;
        try {
            result = ((Optional)classDescriptorCache.get(clazz)).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static ClassDescriptor getClassDescriptor(Class<?> clazz) {
        Class c;
        Metamodel metamodel = Metamodel.get();
        ArrayList scanClasses = new ArrayList();
        scanClasses.add(clazz);
        scanClasses.addAll(ClassUtils.getAllSuperclasses(clazz));
        scanClasses.addAll(ClassUtils.getAllInterfaces(clazz));
        ClassDescriptor result = null;
        Iterator iterator = scanClasses.iterator();
        while (iterator.hasNext() && (result = metamodel.get(c = (Class)iterator.next())) == null) {
        }
        return result;
    }

    public static BiFunction<RDFNode, HashIdCxt, HashCode> createPropertyHashIdProcessor(BiFunction<RDFNode, HashIdCxt, HashCode> globalHashProcessor, P_Path0 path, Supplier<Collection<? extends RDFNode>> valuesSupplier) {
        return (rdfNode, cxt) -> {
            cxt.declareProcessing((RDFNode)rdfNode);
            Collection col = (Collection)valuesSupplier.get();
            int size = col.size();
            ArrayList<HashCode> contribs = new ArrayList<HashCode>(size);
            for (RDFNode item : col) {
                HashCode contrib = (HashCode)globalHashProcessor.apply(item, (HashIdCxt)cxt);
                contribs.add(contrib);
            }
            HashCode hc = col instanceof List ? Hashing.combineOrdered(contribs) : Hashing.combineUnordered(contribs);
            cxt.putHashId((RDFNode)rdfNode, hc);
            return hc;
        };
    }

    public static String classToTag(Class<?> clazz) {
        String result = (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)clazz.getSimpleName());
        return result;
    }

    private static /* synthetic */ Resource lambda$createViewBundleFromMapAndConverter$26(Converter valueConverter, Object o) {
        return (Resource)valueConverter.reverse().convert(o);
    }

    private static /* synthetic */ Object lambda$createViewBundleFromMapAndConverter$25(Converter valueConverter, Resource r) {
        return valueConverter.convert((Object)r);
    }

    private static /* synthetic */ Collection lambda$static$0(Resource s) {
        RdfEntry x = (RdfEntry)s;
        Set<Resource> r = Collections.singleton(x.getOwner());
        return r;
    }

    static {
        ClassDescriptor cd = Metamodel.get().getOrCreate(RdfEntryWithCast.class).registerDirectStringIdProcessor(MapperProxyUtils.createDefaultStringIdProcessor("entry"));
        cd.getOrCreatePropertyDescriptor((P_Path0)new P_Link(NodeFactory.createURI((String)"urn:key"))).setIncludedInHashId(true).setRdfPropertyExcludedFromHashId(false).setIriType(false).setRawProcessor(s -> {
            RdfEntry x = (RdfEntry)s;
            Set<RDFNode> r = Collections.singleton((RDFNode)x.getKey());
            return r;
        }).setAllowDescendPredicate(stmt -> {
            RdfEntryWithCast e = (RdfEntryWithCast)stmt.getSubject();
            boolean r = RDFNode.class.isAssignableFrom(e.getKeyConverter().getTo());
            return r;
        });
        cd.getOrCreatePropertyDescriptor((P_Path0)new P_Link(NodeFactory.createURI((String)"urn:value"))).setIncludedInHashId(true).setRdfPropertyExcludedFromHashId(false).setIriType(false).setRawProcessor(s -> {
            RdfEntry x = (RdfEntry)s;
            Set<RDFNode> r = Collections.singleton((RDFNode)x.getValue());
            return r;
        }).setAllowDescendPredicate(stmt -> {
            RdfEntryWithCast e = (RdfEntryWithCast)stmt.getSubject();
            boolean r = RDFNode.class.isAssignableFrom(e.getKeyConverter().getTo());
            return r;
        });
        classDescriptorCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<ClassDescriptor>>(){

            public Optional<ClassDescriptor> load(Class<?> key) {
                return Optional.ofNullable(MapperProxyUtils.getClassDescriptor(key));
            }
        });
    }

    static class MyPropertyDescriptor {
        String propertyName;
        Method readMethod;
        Method writeMethod;

        MyPropertyDescriptor() {
        }
    }
}

