/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.playground;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;

class Table {
    protected String hashFileBaseName;
    protected List<FileChannel> hashFileChannels = new ArrayList<FileChannel>();
    protected Path mapFile;
    protected FileChannel mapFileChannel;
    protected long mapChannelOffset;
    protected Cache<Long, Node> offsetToNode = Caffeine.newBuilder().maximumSize(10000L).build();
    protected Cache<Node, Long> nodeToOffset = Caffeine.newBuilder().maximumSize(10000L).build();

    public Table() throws IOException {
        this.mapFile = Path.of("/tmp/mapfile.dat", new String[0]);
        this.mapFileChannel = FileChannel.open(this.mapFile, StandardOpenOption.SPARSE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        this.mapFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 1L).put((byte)0);
        this.mapChannelOffset = this.mapFileChannel.size();
    }

    protected FileChannel getHashFileChannel(int index) throws IOException {
        FileChannel result;
        if (index >= this.hashFileChannels.size()) {
            Path newHashFile = Path.of("/tmp/mapfile" + index + ".dat", new String[0]);
            result = FileChannel.open(newHashFile, StandardOpenOption.SPARSE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.hashFileChannels.add(result);
        } else {
            result = this.hashFileChannels.get(index);
        }
        return result;
    }

    public long put(Node node) throws IOException {
        long result;
        if (!node.isURI()) {
            return -1L;
        }
        long hash = Math.abs(node.hashCode());
        int i = 0;
        block0: while (true) {
            FileChannel fc = this.getHashFileChannel(i);
            MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_WRITE, hash * 8L, 40L);
            int bufOffset = 0;
            do {
                long offset = buf.getLong();
                bufOffset += 8;
                if (offset == 0L) {
                    result = this.getOffsetForNode(node, buf, bufOffset);
                    break block0;
                }
                Node entryNode = this.readNodeAtOffset(offset);
                if (!Objects.equals(node, entryNode)) continue;
                result = offset;
                break block0;
            } while (bufOffset < 40);
            ++i;
        }
        return result;
    }

    private long getOffsetForNode(Node node, MappedByteBuffer buf, int bufOffset) throws IOException {
        buf.position(bufOffset - 8);
        byte[] nodeBytes = node.getURI().getBytes(StandardCharsets.UTF_8);
        int dataLen = 4 + nodeBytes.length;
        MappedByteBuffer mapBuf = this.mapFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mapChannelOffset, dataLen);
        mapBuf.putInt(nodeBytes.length);
        mapBuf.put(nodeBytes);
        long result = this.mapChannelOffset;
        buf.asLongBuffer().put(result);
        this.offsetToNode.put((Object)result, (Object)node);
        this.mapChannelOffset += (long)dataLen;
        return result;
    }

    private Node readNodeAtOffset(long offset) throws IOException {
        MappedByteBuffer mapBuf1 = this.mapFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, 4L);
        int len = mapBuf1.asIntBuffer().get();
        byte[] data = new byte[len];
        MappedByteBuffer mapBuf2 = this.mapFileChannel.map(FileChannel.MapMode.READ_ONLY, offset + 4L, len);
        mapBuf2.get(data);
        String str = new String(data, StandardCharsets.UTF_8);
        Node entryNode = NodeFactory.createURI((String)str);
        return entryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node parseNode(String str) {
        Node result = null;
        LabelToNode decoder = LabelToNode.createUseLabelEncoded();
        try (Tokenizer tokenizer = TokenizerText.create().fromString(str).build();){
            if (tokenizer.hasNext()) {
                Token token = tokenizer.next();
                Node node = token.asNode();
                if (node != null && node.isBlank()) {
                    String label = node.getBlankNodeLabel();
                    node = (Node)decoder.get(null, (Object)label);
                }
                result = node;
            }
            if (tokenizer.hasNext()) {
                throw new IllegalArgumentException("String parsed into more than 1 node.");
            }
        }
        return result;
    }

    public void close() throws IOException {
        for (FileChannel fc : this.hashFileChannels) {
            fc.close();
        }
        this.mapFileChannel.close();
    }
}

