/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.udf.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.util.function.FixpointIteration;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.model.shacl.domain.ShHasPrefixes;
import org.aksw.jenax.model.shacl.util.ShPrefixUtils;
import org.aksw.jenax.model.udf.api.UdfDefinition;
import org.aksw.jenax.model.udf.api.UdfVocab;
import org.aksw.jenax.model.udf.api.UserDefinedFunctionResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.user.ExprTransformExpand;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.function.user.UserDefinedFunctionFactory;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDefinedFunctions {
    private static final Logger logger = LoggerFactory.getLogger(UserDefinedFunctions.class);

    public static ExtendedIterator<UserDefinedFunctionResource> listUserDefinedFunctions(Model model) {
        return model.listSubjectsWithProperty(RDF.type, (RDFNode)UdfVocab.UserDefinedFunction).mapWith(x -> (UserDefinedFunctionResource)x.as(UserDefinedFunctionResource.class));
    }

    public static void registerAll(Map<String, UserDefinedFunctionDefinition> map) {
        UserDefinedFunctionFactory f = UserDefinedFunctionFactory.getFactory();
        for (UserDefinedFunctionDefinition udfd : map.values()) {
            f.add(udfd.getUri(), udfd.getBaseExpr(), udfd.getArgList());
        }
    }

    public static Map<String, UserDefinedFunctionDefinition> load(Model model, Set<String> activeProfiles) {
        LinkedHashMap<String, UserDefinedFunctionDefinition> result = new LinkedHashMap<String, UserDefinedFunctionDefinition>();
        List fns = UserDefinedFunctions.listUserDefinedFunctions(model).toList();
        for (UserDefinedFunctionResource fn : fns) {
            UserDefinedFunctions.resolveUdf(result, fn, activeProfiles);
        }
        return result;
    }

    public static String forceIri(Resource r) {
        String result = r.isURIResource() ? r.getURI() : "_:" + r.getId().getLabelString();
        Objects.requireNonNull(result, "Could not craft IRI from " + String.valueOf(r));
        return result;
    }

    public static void resolveUdf(Map<String, UserDefinedFunctionDefinition> result, UserDefinedFunctionResource fn, Set<String> activeProfiles) {
        String fnIri = UserDefinedFunctions.forceIri(fn);
        UserDefinedFunctionDefinition fnUdfd = result.get(fnIri);
        if (fnUdfd == null) {
            ArrayList<UdfDefinition> activeUdfs = new ArrayList<UdfDefinition>();
            for (UdfDefinition def : fn.getDefinitions()) {
                Set<Resource> requiredProfiles = def.getProfiles();
                Set requiredProfileIris = requiredProfiles.stream().filter(RDFNode::isURIResource).map(Resource::getURI).collect(Collectors.toSet());
                Sets.SetView overlap = Sets.intersection(requiredProfileIris, activeProfiles);
                if (!requiredProfiles.isEmpty() && overlap.isEmpty()) continue;
                activeUdfs.add(def);
            }
            if (activeUdfs.isEmpty()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("User defined function " + fnIri + " has no candidate for profiles " + String.valueOf(activeProfiles));
                }
            } else {
                if (activeUdfs.size() > 1) {
                    throw new RuntimeException("Expected exactly 1 definition for " + fnIri + "; got: " + String.valueOf(activeUdfs));
                }
                UdfDefinition activeUdf = (UdfDefinition)Iterables.getFirst(activeUdfs, null);
                UserDefinedFunctionResource ra = activeUdf.getAliasFor();
                if (Boolean.TRUE.equals(activeUdf.mapsToPropertyFunction())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Mapped property function: " + String.valueOf(activeUdf) + ", aliasFor: " + String.valueOf(ra));
                    }
                    UserDefinedFunctionDefinition ud = new UserDefinedFunctionDefinition(fnIri, ExprUtils.parse((String)("<" + fnIri + ">(?s)")), Arrays.asList(Vars.s));
                    result.put(ud.getUri(), ud);
                } else if (ra != null) {
                    UserDefinedFunctionResource alias = (UserDefinedFunctionResource)ra.as(UserDefinedFunctionResource.class);
                    if (alias != null) {
                        UserDefinedFunctions.resolveUdf(result, alias, activeProfiles);
                        String iri = UserDefinedFunctions.forceIri(alias);
                        UserDefinedFunctionDefinition udfd = result.get(iri);
                        if (udfd == null) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Could not resolve " + iri);
                            }
                        } else {
                            UserDefinedFunctionDefinition ud = new UserDefinedFunctionDefinition(fnIri, udfd.getBaseExpr(), udfd.getArgList());
                            result.put(ud.getUri(), ud);
                        }
                    }
                } else {
                    UserDefinedFunctionDefinition udfd = UserDefinedFunctions.toJena(fnIri, activeUdf);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Registering " + String.valueOf(udfd));
                    }
                    result.put(udfd.getUri(), udfd);
                }
            }
        }
    }

    public static Expr expandMacro(Map<String, UserDefinedFunctionDefinition> macros, String udfUri, Expr ... args) {
        E_Function e = new E_Function(udfUri, new ExprList(Arrays.asList(args)));
        Expr result = UserDefinedFunctions.expandMacro(macros, (Expr)e);
        return result;
    }

    public static Expr expandMacro(Map<String, UserDefinedFunctionDefinition> macros, Expr e) {
        ExprTransformExpand xform = new ExprTransformExpand(macros);
        e = (Expr)FixpointIteration.apply((int)100, (Object)e, arg_0 -> UserDefinedFunctions.lambda$expandMacro$1((ExprTransform)xform, arg_0));
        e = (Expr)FixpointIteration.apply((int)100, (Object)e, ExprLib::foldConstants);
        return e;
    }

    public static NodeValue eval(Map<String, UserDefinedFunctionDefinition> macros, String udfUri, Expr ... args) {
        Expr expr = UserDefinedFunctions.expandMacro(macros, udfUri, args);
        NodeValue result = ExprUtils.eval((Expr)expr);
        return result;
    }

    public static UserDefinedFunctionDefinition toJena(String iri, UdfDefinition r) {
        PrefixMapping pm = Prefixes.adapt((PrefixMap)ShPrefixUtils.collect((ShHasPrefixes)r));
        if (logger.isDebugEnabled()) {
            logger.debug("Processing user defined function definition: " + iri + ": " + String.valueOf(pm));
        }
        List<String> paramsStr = r.getParams();
        List params = paramsStr.stream().map(Var::alloc).collect(Collectors.toList());
        String exprStr = r.getExpr();
        if (exprStr == null) {
            throw new NullPointerException("No expression present on resource: " + iri);
        }
        Expr e = ExprUtils.parse((String)exprStr, (PrefixMapping)pm);
        UserDefinedFunctionDefinition result = new UserDefinedFunctionDefinition(iri, e, params);
        return result;
    }

    private static /* synthetic */ Expr lambda$expandMacro$1(ExprTransform xform, Expr x) {
        return ExprTransformer.transform((ExprTransform)xform, (Expr)x);
    }
}

