/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.shacl.domain;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.model.shacl.domain.ShPrefixDeclaration;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;

@ResourceView
public interface ShPrefixMapping
extends Resource {
    @Iri(value="http://www.w3.org/2002/07/owl#import")
    public Set<ShPrefixMapping> getOwlImports();

    @Iri(value="http://www.w3.org/ns/shacl#declare")
    public Set<ShPrefixDeclaration> getPrefixDeclarations();

    default public ShPrefixMapping put(String prefix, String value) {
        Set<ShPrefixDeclaration> set = this.getPrefixDeclarations();
        boolean done = false;
        for (ShPrefixDeclaration def : set) {
            String p = def.getPrefix();
            if (!Objects.equals(prefix, prefix)) continue;
            def.setIri(value);
            done = true;
            break;
        }
        if (!done) {
            ShPrefixDeclaration n = ((ShPrefixDeclaration)this.getModel().createResource().as(ShPrefixDeclaration.class)).setPrefix(prefix).setIri(value);
            set.add(n);
        }
        return this;
    }

    default public Map<String, String> getMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<ShPrefixDeclaration> set = this.getPrefixDeclarations();
        for (ShPrefixDeclaration def : set) {
            String prefix = def.getPrefix();
            String namespace = def.getIri();
            result.put(prefix, namespace);
        }
        return result;
    }

    default public PrefixMapping addTo(PrefixMapping pm) {
        Set<ShPrefixDeclaration> set = this.getPrefixDeclarations();
        for (ShPrefixDeclaration def : set) {
            String prefix = def.getPrefix();
            String iri = def.getIri();
            pm.setNsPrefix(prefix, iri);
        }
        return pm;
    }
}

