/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.shacl.util;

import com.google.common.html.HtmlEscapers;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.out.NodeFmtLib;

public class RDFUtils {
    public Set<Property> properties(RDFNode rdfNode) {
        return rdfNode != null && rdfNode.isResource() ? new LinkedHashSet(rdfNode.asResource().listProperties().mapWith(Statement::getPredicate).toList()) : Collections.emptySet();
    }

    public Set<RDFNode> objects(RDFNode rdfNode, Property p) {
        return rdfNode != null && rdfNode.isResource() ? new LinkedHashSet(rdfNode.asResource().listProperties(p).mapWith(Statement::getObject).toList()) : Collections.emptySet();
    }

    public String toHtml(RDFNode rdfNode) {
        Node node = rdfNode.asNode();
        String result = this.toHtml(node);
        return result;
    }

    public boolean strContains(Object str, Object substr) {
        boolean result;
        if (str == null) {
            result = false;
        } else {
            String strStr = Objects.toString(str);
            String substrStr = Objects.toString(substr);
            result = strStr.contains(substrStr);
        }
        return result;
    }

    public String toHtml(Node node) {
        String result = "<rdf-node value=\"" + HtmlEscapers.htmlEscaper().escape(NodeFmtLib.strNT((Node)node)) + "\"></rdf-node>";
        return result;
    }
}

