/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.shacl.util;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.attributes.methodaccess.MethodAccessValidator;
import io.pebbletemplates.pebble.attributes.methodaccess.NoOpMethodAccessValidator;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.loader.StringLoader;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aksw.jenax.model.shacl.domain.ShPrefixDeclaration;
import org.aksw.jenax.model.shacl.util.RDFUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ShPebbleUtils {
    public static void main(String[] args) {
        Model m = ModelFactory.createDefaultModel();
        Resource r = (Resource)m.createResource().addProperty(RDF.type, (RDFNode)m.createResource("Foo")).addProperty(RDF.type, (RDFNode)m.createResource("Bar")).addProperty(RDF.type, (RDFNode)m.createResource("Baz")).addProperty(RDFS.label, "bar").as(ShPrefixDeclaration.class);
        System.out.println(ShPebbleUtils.createRenderer("<h1>Greetings {{this.getProperty(RDFS.label).getString()}}</h1>").apply(Map.of("this", r)));
        System.out.println(ShPebbleUtils.createRenderer("<h1>Hello {{this.name}}</h1>").apply(Map.of("this", r)));
        System.out.println(ShPebbleUtils.createRenderer("<ul> {% for stmt in this.listProperties().toList() %} <li>item</li> {% endfor %} </ul>").apply(Map.of("this", r)));
        System.out.println(ShPebbleUtils.createRenderer("<ul> {% set items = this.listProperties().toSet() %} items: {{items}} {% for stmt in items %} <li>item</li> {% endfor %} </ul>").apply(Map.of("this", r)));
        System.out.println(ShPebbleUtils.forRdfNode("<table>\n{% for p in RDF.properties(this) %}\n  {% for o in RDF.objects(this, p) %}\n     {% set oStr = RDF.strContains(o.getURI(), 'Baz') %}      oStr: {{oStr}}    <tr>\n      <td> {% if loop.isFirst %} {{p}} {% endif %} </td>\n      <td> {{RDF.toHtml(o) | raw}} </td>\n    </tr>\n  {% endfor %}\n{% endfor %}\n</table>\n").apply((RDFNode)r));
    }

    public static Function<RDFNode, String> forRdfNode(String templateString) {
        Function<Map<String, Object>, String> renderer = ShPebbleUtils.createRenderer(templateString);
        return rdfNode -> {
            HashMap<String, Object> cxt = new HashMap<String, Object>();
            cxt.put("this", rdfNode);
            cxt.put("RDF", new RDFUtils());
            String r = (String)renderer.apply(cxt);
            return r;
        };
    }

    public static Function<Map<String, Object>, String> createRenderer(String templateString) {
        StringLoader loader = new StringLoader();
        PebbleEngine engine = new PebbleEngine.Builder().methodAccessValidator((MethodAccessValidator)new NoOpMethodAccessValidator()).loader((Loader)loader).build();
        PebbleTemplate compiledTemplate = engine.getTemplate(templateString);
        return cxt -> {
            String r;
            try (StringWriter writer = new StringWriter();){
                compiledTemplate.evaluate((Writer)writer, cxt);
                r = ((Object)writer).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return r;
        };
    }

    static {
        JenaSystem.init();
    }
}

