/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.shacl.util;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionUtils;
import org.aksw.jenax.model.shacl.domain.ShNodeShape;
import org.aksw.jenax.model.shacl.domain.ShPropertyShape;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.Path;
import org.topbraid.shacl.vocabulary.SH;

public class ShUtils {
    public static final Query NodeShapeQuery = QueryFactory.create((String)String.join((CharSequence)StandardSystemProperty.LINE_SEPARATOR.value(), "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX sh: <http://www.w3.org/ns/shacl#>", "SELECT DISTINCT ?s {", "  ?s ((sh:and|sh:or|sh:xone)/rdf:rest*/rdf:first)*/sh:property []", "  FILTER NOT EXISTS { [] ((sh:and|sh:or|sh:xone)/rdf:rest*/rdf:first)+ ?s }", "}"));

    public static List<ShNodeShape> listNodeShapes(Model model) {
        List result = QueryExecutionUtils.executeRdfList(q -> QueryExecutionFactory.create((Query)q, (Model)model), (Query)NodeShapeQuery, ShNodeShape.class);
        return result;
    }

    public static Stream<ShPropertyShape> streamPropertyShapes(Model model) {
        return Iter.asStream((Iterator)model.listResourcesWithProperty(SH.path)).map(r -> (ShPropertyShape)r.as(ShPropertyShape.class));
    }

    public static Multimap<P_Path0, ShPropertyShape> indexGlobalPropertyShapes(Model model) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        try (Stream<ShPropertyShape> stream = ShUtils.streamPropertyShapes(model);){
            stream.forEach(arg_0 -> ShUtils.lambda$indexGlobalPropertyShapes$2((Multimap)result, arg_0));
        }
        return result;
    }

    private static /* synthetic */ void lambda$indexGlobalPropertyShapes$2(Multimap result, ShPropertyShape pshape) {
        Resource r = pshape.getPath();
        Path path = ShaclPaths.parsePath((Graph)r.getModel().getGraph(), (Node)r.asNode());
        if (path instanceof P_Path0) {
            result.put((Object)((P_Path0)path), (Object)pshape);
        }
    }
}

