/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.shacl.template.domain;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;

@ResourceView
public interface HasTemplate
extends Resource {
    @Iri(value="http://www.example.org/template")
    public Set<Node> getTemplateNodes();

    default public String getTemplate(String datatype) {
        Set<Node> nodes = this.getTemplateNodes();
        Set matches = nodes.stream().filter(Node::isLiteral).filter(node -> Objects.equals(node.getLiteralDatatypeURI(), datatype)).collect(Collectors.toSet());
        Node match = (Node)IterableUtils.expectZeroOrOneItems(matches);
        String result = match == null ? null : match.getLiteralLexicalForm();
        return result;
    }
}

