/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.model.prov;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import org.aksw.jenax.annotation.reprogen.HashId;
import org.aksw.jenax.annotation.reprogen.Inverse;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.model.prov.Entity;
import org.aksw.jenax.model.prov.Plan;
import org.aksw.jenax.model.prov.ProvComponent;
import org.aksw.jenax.model.prov.QualifiedAssociation;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

@ResourceView
public interface Activity
extends ProvComponent {
    @Iri(value="http://www.w3.org/ns/prov#hadPlan")
    @HashId
    public Plan getHadPlan();

    public Activity setHadPlan(Resource var1);

    default public Plan getOrSetHadPlan() {
        return (Plan)JenaPluginUtils.getOrSet((RDFNode)this, Plan.class, this::getHadPlan, this::setHadPlan);
    }

    @Iri(value="http://www.w3.org/ns/prov#wasGeneratedBy")
    @Inverse
    @HashId
    public Node getGeneratedNode();

    public Activity setGeneratedNode(Node var1);

    @Iri(value="http://www.w3.org/ns/prov#wasGeneratedBy")
    @Inverse
    public Entity getGenerated();

    public Activity setGenerated(Resource var1);

    @Iri(value="http://www.w3.org/ns/prov#wasAssociatedWith")
    @HashId
    public Entity getWasAssociatedWith();

    public Activity setWasAssociatedWith(Resource var1);

    @Iri(value="http://www.w3.org/ns/prov#qualifiedAssociation")
    public Set<QualifiedAssociation> getQualifiedAssociations();

    @Iri(value="http://www.w3.org/ns/prov#startedAtTime")
    public XSDDateTime getStartedAtTimeDt();

    public Activity setStartedAtTimeDt(XSDDateTime var1);

    @Iri(value="http://www.w3.org/ns/prov#endedAtTime")
    public XSDDateTime getEndedAtTimeDt();

    public Activity setEndedAtTimeDt(XSDDateTime var1);

    default public Instant getStartedAtTime() {
        return Instant.ofEpochSecond(this.getStartedAtTimeDt().getFullSeconds());
    }

    default public Activity setStartedAtTime(Instant instant) {
        return this.setStartedAtTimeDt(new XSDDateTime((Calendar)GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC))));
    }

    default public Instant getEndedAtTime() {
        return Instant.ofEpochSecond(this.getEndedAtTimeDt().getFullSeconds());
    }

    default public Activity setEndedAtTime(Instant instant) {
        return this.setEndedAtTimeDt(new XSDDateTime((Calendar)GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC))));
    }
}

