/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.dcat.jena.domain.api;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.aksw.dcat.jena.domain.api.DcatDataset;
import org.aksw.dcat.jena.domain.api.DcatDistribution;
import org.aksw.dcat.jena.domain.api.DcatDownloadUrl;
import org.aksw.dcat.jena.domain.api.DcatIdType;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCAT;

public class DcatUtils {
    public static String getFirstDownloadUrlFromDistribution(Resource dcatDistribution) {
        String result = ResourceUtils.listPropertyValues((Resource)dcatDistribution, (Property)DCAT.downloadURL).toList().stream().filter(RDFNode::isURIResource).map(RDFNode::asResource).map(Resource::getURI).sorted().findFirst().orElse(null);
        return result;
    }

    public static String getFirstDownloadUrl(Resource dcatDataset) {
        String result = ResourceUtils.listPropertyValues((Resource)dcatDataset, (Property)DCAT.distribution, Resource.class).toList().stream().flatMap(d -> ResourceUtils.listPropertyValues((Resource)d, (Property)DCAT.downloadURL).toList().stream()).filter(RDFNode::isURIResource).map(RDFNode::asResource).map(Resource::getURI).sorted().findFirst().orElse(null);
        return result;
    }

    public static Set<? extends DcatDistribution> resolveDistributions(Resource res) {
        Set<DcatDistribution> result;
        DcatDistribution dist = (DcatDistribution)res.as(DcatDistribution.class);
        if (dist.getDcatDatasets(DcatDataset.class).isEmpty()) {
            DcatDownloadUrl durl = (DcatDownloadUrl)res.as(DcatDownloadUrl.class);
            result = durl.getDistributions();
            if (result.isEmpty()) {
                DcatDataset ds = (DcatDataset)res.as(DcatDataset.class);
                result = ds.getDistributions();
            }
        } else {
            result = Collections.singleton(dist);
        }
        return result;
    }

    public static DcatDistribution resolveDistribution(Resource res) {
        Set<? extends DcatDistribution> candidates = DcatUtils.resolveDistributions(res);
        DcatDistribution result = (DcatDistribution)Iterables.getOnlyElement(candidates);
        return result;
    }

    public static Resource getRelatedId(DcatDistribution distribution, DcatIdType idType) {
        Set<? extends Resource> candidates = DcatUtils.getRelatedIds(distribution, idType);
        Resource result = (Resource)Iterables.getOnlyElement(candidates);
        return result;
    }

    public static Set<? extends Resource> getRelatedIds(DcatDistribution distribution, DcatIdType idType) {
        return switch (idType) {
            case DcatIdType.DATASET -> distribution.getDcatDatasets(DcatDataset.class);
            case DcatIdType.DISTRIBUTION -> Collections.singleton(distribution);
            case DcatIdType.FILE -> distribution.getDownloadUrlResources();
            default -> throw new IllegalStateException("Unknown id type: " + String.valueOf((Object)idType));
        };
    }
}

