/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.dcat.jena.domain.api;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.dcat.jena.domain.api.DcatDatasetCore;
import org.aksw.dcat.jena.domain.api.DcatDistribution;
import org.aksw.dcat.jena.domain.api.DcatEntity;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.apache.jena.rdf.model.Resource;

public interface DcatDataset
extends DcatEntity,
DcatDatasetCore {
    @Iri(value="dcat:distribution")
    public <T extends Resource> Set<T> getDistributionsAs(Class<T> var1);

    default public Set<? extends DcatDistribution> getDistributions() {
        return this.getDistributionsAs(DcatDistribution.class);
    }

    default public Set<DcatDistribution> getBasicDistributions() {
        return this.getDistributionsAs(DcatDistribution.class);
    }

    default public DcatDistribution addNewDistribution(String iri) {
        DcatDistribution result = (DcatDistribution)this.getModel().createResource(iri).as(DcatDistribution.class);
        this.getBasicDistributions().add(result);
        return result;
    }

    @Override
    @Iri(value="dcterms:keyword")
    public Collection<String> getKeywords();

    public static String getLabel(DcatDataset ds) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = ds::getTitle;
        supplierArray[1] = ds::getIdentifier;
        supplierArray[2] = () -> ds.isURIResource() ? ds.getURI() : Integer.toString(System.identityHashCode(ds));
        String result = (String)ObjectUtils.coalesce((Supplier[])supplierArray);
        return result;
    }
}

