/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph.index.jena;

import com.google.common.collect.BiMap;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.tagmap.TagMap;
import org.aksw.commons.graph.index.core.SetOps;
import org.aksw.commons.graph.index.core.SubgraphIsomorphismIndex;
import org.aksw.commons.graph.index.core.SubgraphIsomorphismIndexFlat;
import org.aksw.commons.graph.index.core.SubgraphIsomorphismIndexImpl;
import org.aksw.commons.graph.index.core.SubgraphIsomorphismIndexTagBased;
import org.aksw.commons.graph.index.jena.IsoMatcherImpl;
import org.aksw.commons.graph.index.jena.SetOpsJGraphTRdfJena;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.NodeCmp;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.jgrapht.Graph;

public class SubgraphIsomorphismIndexJena {
    public static <K> SubgraphIsomorphismIndex<K, Graph<Node, Triple>, Node> createFlat() {
        SubgraphIsomorphismIndexFlat result = new SubgraphIsomorphismIndexFlat((SetOps)SetOpsJGraphTRdfJena.INSTANCE, new IsoMatcherImpl(SubgraphIsomorphismIndexJena::createNodeComparator, SubgraphIsomorphismIndexJena::createEdgeComparator));
        return result;
    }

    public static <K> SubgraphIsomorphismIndex<K, Graph<Node, Triple>, Node> create() {
        SubgraphIsomorphismIndexImpl result = new SubgraphIsomorphismIndexImpl((SetOps)SetOpsJGraphTRdfJena.INSTANCE, SubgraphIsomorphismIndexJena::extractGraphTags, NodeCmp::compareRDFTerms, new IsoMatcherImpl(SubgraphIsomorphismIndexJena::createNodeComparator, SubgraphIsomorphismIndexJena::createEdgeComparator));
        return result;
    }

    public static <K> SubgraphIsomorphismIndexTagBased<K, Graph<Node, Triple>, Node, Node> createTagBased(TagMap<K, Node> tagMap) {
        SubgraphIsomorphismIndexTagBased result = new SubgraphIsomorphismIndexTagBased(new IsoMatcherImpl(SubgraphIsomorphismIndexJena::createNodeComparator, SubgraphIsomorphismIndexJena::createEdgeComparator), SubgraphIsomorphismIndexJena::extractGraphTags, tagMap);
        return result;
    }

    public static Comparator<Node> createNodeComparator(BiMap<? extends Node, ? extends Node> baseIso) {
        Comparator result = (x, y) -> SubgraphIsomorphismIndexJena.compareNodes(baseIso, x, y);
        return result;
    }

    public static Comparator<Triple> createEdgeComparator(BiMap<? extends Node, ? extends Node> baseIso) {
        Comparator result = (x, y) -> SubgraphIsomorphismIndexJena.compareNodes(baseIso, x.getPredicate(), y.getPredicate());
        return result;
    }

    public static int compareNodes(BiMap<? extends Node, ? extends Node> baseIso, Node i, Node j) {
        int result = i.isVariable() && j.isVariable() || i.isBlank() && j.isBlank() || Objects.equals(baseIso.get((Object)i), j) ? 0 : NodeCmp.compareRDFTerms((Node)i, (Node)j);
        return result;
    }

    public static Set<Node> extractGraphTags(Graph<Node, Triple> graph) {
        Set<Node> result = graph.edgeSet().stream().flatMap(t -> Arrays.asList(t.getSubject(), t.getPredicate(), t.getObject()).stream()).filter(n -> n.isURI() || n.isLiteral()).collect(Collectors.toSet());
        return result;
    }

    public static Collection<?> extractGraphTags2(org.apache.jena.graph.Graph graph) {
        Set result = Streams.stream((Iterator)GraphUtils.allNodes((org.apache.jena.graph.Graph)graph)).filter(n -> n.isURI() || n.isLiteral()).collect(Collectors.toSet());
        return result;
    }
}

