/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph.index.jena;

import com.google.common.collect.BiMap;
import java.util.Comparator;
import java.util.function.Function;
import org.aksw.combinatorics.solvers.ProblemNeighborhoodAware;
import org.aksw.commons.graph.index.core.IsoMatcher;
import org.aksw.commons.graph.index.jgrapht.ProblemNodeMappingGraph;
import org.jgrapht.Graph;

public class IsoMatcherImpl<V, E, G extends Graph<V, E>>
implements IsoMatcher<G, V> {
    protected Function<BiMap<? extends V, ? extends V>, Comparator<V>> createVertexComparator;
    protected Function<BiMap<? extends V, ? extends V>, Comparator<E>> createEdgeComparator;

    public IsoMatcherImpl(Function<BiMap<? extends V, ? extends V>, Comparator<V>> createVertexComparator, Function<BiMap<? extends V, ? extends V>, Comparator<E>> createEdgeComparator) {
        this.createVertexComparator = createVertexComparator;
        this.createEdgeComparator = createEdgeComparator;
    }

    public ProblemNeighborhoodAware<BiMap<V, V>, V> toProblem(BiMap<? extends V, ? extends V> baseIso, G viewGraph, G insertGraph) {
        ProblemNodeMappingGraph result = new ProblemNodeMappingGraph(baseIso, viewGraph, insertGraph, this.createVertexComparator, this.createEdgeComparator);
        return result;
    }

    public Iterable<BiMap<V, V>> match(BiMap<? extends V, ? extends V> baseIso, G viewGraph, G insertGraph) {
        ProblemNeighborhoodAware problem = this.toProblem(baseIso, viewGraph, insertGraph);
        Iterable<BiMap<V, V>> result = () -> problem.generateSolutions().iterator();
        return result;
    }
}

