/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import java.util.Set;
import org.aksw.commons.jena.jgrapht.SetOfStatementsFromModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;

public class IntrusiveEdgesSpecificsJenaModel
implements IntrusiveEdgesSpecifics<RDFNode, Statement> {
    private static final long serialVersionUID = 7382770638639511162L;
    protected Model model;
    protected Property confinementProperty;

    public IntrusiveEdgesSpecificsJenaModel(Model model, Property confinementProperty) {
        this.model = model;
        this.confinementProperty = confinementProperty;
    }

    public RDFNode getEdgeSource(Statement e) {
        return e.getSubject();
    }

    public RDFNode getEdgeTarget(Statement e) {
        return e.getObject();
    }

    public boolean add(Statement e, RDFNode sourceVertex, RDFNode targetVertex) {
        Statement stmt = this.model.createStatement(sourceVertex.asResource(), this.confinementProperty, targetVertex);
        boolean tmp = this.model.contains(stmt);
        if (!tmp) {
            this.model.add(stmt);
        }
        boolean result = !tmp;
        return result;
    }

    public boolean containsEdge(Statement e) {
        boolean result = this.model.contains(e);
        return result;
    }

    public Set<Statement> getEdgeSet() {
        return new SetOfStatementsFromModel(this.model, this.confinementProperty);
    }

    public void remove(Statement e) {
        this.model.remove(e);
    }

    public double getEdgeWeight(Statement e) {
        return 1.0;
    }

    public void setEdgeWeight(Statement e, double weight) {
        if (weight != 1.0) {
            throw new UnsupportedOperationException();
        }
    }
}

