/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.jena.jgrapht.EdgeFactoryJenaGraph;
import org.aksw.commons.jena.jgrapht.IntrusiveEdgesSpecificsJenaGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;

public class PseudoGraphJenaGraph
implements org.jgrapht.Graph<Node, Triple> {
    protected Graph graph;
    protected GraphType graphType;
    protected Node confinementPredicate;
    protected EdgeFactoryJenaGraph edgeSupplier;
    protected IntrusiveEdgesSpecifics<Node, Triple> intrusiveEdgesSpecifics;

    public PseudoGraphJenaGraph(Graph graph) {
        this(graph, (GraphType)DefaultGraphType.directedPseudograph());
    }

    public PseudoGraphJenaGraph(Graph graph, GraphType graphType) {
        this(graph, graphType, Node.ANY, null);
    }

    public PseudoGraphJenaGraph(Graph graph, Node confinementPredicate) {
        this(graph, (GraphType)DefaultGraphType.directedPseudograph(), confinementPredicate);
    }

    public PseudoGraphJenaGraph(Graph graph, GraphType graphType, Node confinementPredicate) {
        this(graph, graphType, confinementPredicate, confinementPredicate);
    }

    public PseudoGraphJenaGraph(Graph graph, GraphType graphType, Node confinementPredicate, Node insertPredicate) {
        this.graph = graph;
        this.graphType = graphType;
        this.confinementPredicate = confinementPredicate;
        this.edgeSupplier = new EdgeFactoryJenaGraph(insertPredicate);
        this.intrusiveEdgesSpecifics = new IntrusiveEdgesSpecificsJenaGraph(graph, confinementPredicate);
    }

    public Set<Triple> getAllEdges(Node sourceVertex, Node targetVertex) {
        return this.find(sourceVertex, this.confinementPredicate, targetVertex).toSet();
    }

    public Triple getEdge(Node sourceVertex, Node targetVertex) {
        Triple result;
        Set<Triple> edges = this.getAllEdges(sourceVertex, targetVertex);
        Triple triple = result = edges.isEmpty() ? null : edges.iterator().next();
        if (result == null) {
            throw new RuntimeException("null edge should not happen");
        }
        return result;
    }

    public Supplier<Triple> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public Triple addEdge(Node sourceVertex, Node targetVertex) {
        Triple result = this.edgeSupplier.createEdge(sourceVertex, targetVertex);
        this.graph.add(result);
        return result;
    }

    public boolean addEdge(Node sourceVertex, Node targetVertex, Triple e) {
        boolean result;
        boolean isValid;
        boolean bl = isValid = e.getSubject().equals((Object)sourceVertex) && e.getObject().equals((Object)targetVertex);
        if (!isValid) {
            throw new RuntimeException("Source and/or target vertex does not match those of the triple: " + String.valueOf(sourceVertex) + " " + String.valueOf(targetVertex) + " " + String.valueOf(e));
        }
        if (!this.confinementPredicate.equals((Object)Node.ANY) && e.getPredicate().equals((Object)this.confinementPredicate)) {
            throw new RuntimeException("Graph is confined to predicate " + String.valueOf(this.confinementPredicate) + " therefore cannot add edge with predicate " + String.valueOf(e));
        }
        boolean bl2 = result = !this.graph.contains(e);
        if (result) {
            this.graph.add(e);
        }
        return result;
    }

    public boolean addVertex(Node v) {
        boolean result = !this.containsVertex(v);
        return result;
    }

    public boolean containsEdge(Node sourceVertex, Node targetVertex) {
        boolean result = this.find(sourceVertex, this.confinementPredicate, targetVertex).hasNext();
        return result;
    }

    public boolean containsEdge(Triple e) {
        boolean result = this.find(e.getSubject(), e.getPredicate(), e.getObject()).hasNext();
        return result;
    }

    public boolean containsVertex(Node v) {
        boolean result = this.find(v, this.confinementPredicate, Node.ANY).hasNext() || this.find(Node.ANY, this.confinementPredicate, v).hasNext();
        return result;
    }

    public Set<Triple> edgeSet() {
        Set result = this.find(Node.ANY, this.confinementPredicate, Node.ANY).toSet();
        return result;
    }

    public int degreeOf(Node vertex) {
        return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
    }

    public Set<Triple> edgesOf(Node vertex) {
        HashSet<Triple> result = new HashSet<Triple>();
        this.find(vertex, this.confinementPredicate, Node.ANY).forEachRemaining(result::add);
        this.find(Node.ANY, this.confinementPredicate, vertex).forEachRemaining(result::add);
        return result;
    }

    public boolean removeAllEdges(Collection<? extends Triple> edges) {
        Iterator it = edges.stream().map(e -> e).iterator();
        GraphUtil.delete((Graph)this.graph, it);
        return true;
    }

    public Set<Triple> removeAllEdges(Node sourceVertex, Node targetVertex) {
        this.graph.remove(sourceVertex, this.confinementPredicate, targetVertex);
        return null;
    }

    public boolean removeAllVertices(Collection<? extends Node> vertices) {
        boolean result = false;
        for (Node node : vertices) {
            result = result || this.removeVertex(node);
        }
        return result;
    }

    public Triple removeEdge(Node sourceVertex, Node targetVertex) {
        Triple result = Triple.create((Node)sourceVertex, (Node)this.confinementPredicate, (Node)targetVertex);
        this.removeEdge(result);
        return null;
    }

    public boolean removeEdge(Triple e) {
        if (!e.getPredicate().equals((Object)this.confinementPredicate) && !this.confinementPredicate.equals((Object)Node.ANY)) {
            throw new RuntimeException("Cannot remove edge outside of confinement - predicate must be: " + String.valueOf(this.confinementPredicate) + " but got " + String.valueOf(e));
        }
        this.graph.remove(e.getSubject(), e.getPredicate(), e.getObject());
        return true;
    }

    public boolean removeVertex(Node v) {
        this.graph.remove(v, this.confinementPredicate, Node.ANY);
        this.graph.remove(Node.ANY, this.confinementPredicate, v);
        return true;
    }

    public Set<Node> vertexSet() {
        HashSet<Node> result = new HashSet<Node>();
        this.find(Node.ANY, this.confinementPredicate, Node.ANY).forEachRemaining(triple -> {
            result.add(triple.getSubject());
            result.add(triple.getObject());
        });
        return result;
    }

    public Node getEdgeSource(Triple e) {
        return e.getSubject();
    }

    public Node getEdgeTarget(Triple e) {
        return e.getObject();
    }

    public GraphType getType() {
        return this.graphType;
    }

    public double getEdgeWeight(Triple e) {
        return 1.0;
    }

    public void setEdgeWeight(Triple triple, double weight) {
        throw new UnsupportedOperationException("RDF graph is not weighted");
    }

    public int inDegreeOf(Node vertex) {
        int result = this.incomingEdgesOf(vertex).size();
        return result;
    }

    public Set<Triple> incomingEdgesOf(Node vertex) {
        Set result = this.find(Node.ANY, this.confinementPredicate, vertex).toSet();
        return result;
    }

    public int outDegreeOf(Node vertex) {
        int result = this.outgoingEdgesOf(vertex).size();
        return result;
    }

    public Set<Triple> outgoingEdgesOf(Node vertex) {
        Set result = this.find(vertex, this.confinementPredicate, Node.ANY).toSet();
        return result;
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        ExtendedIterator result = this.graph.find(s, p, o);
        return result;
    }

    public String toString() {
        return "PseudoGraphJenaGraph [graph=" + String.valueOf(this.graph) + ", confinementPredicate=" + String.valueOf(this.confinementPredicate) + ", edgeFactory=" + String.valueOf(this.edgeSupplier) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.confinementPredicate == null ? 0 : this.confinementPredicate.hashCode());
        result = 31 * result + (this.edgeSupplier == null ? 0 : this.edgeSupplier.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoGraphJenaGraph other = (PseudoGraphJenaGraph)obj;
        if (this.confinementPredicate == null ? other.confinementPredicate != null : !this.confinementPredicate.equals((Object)other.confinementPredicate)) {
            return false;
        }
        if (this.edgeSupplier == null ? other.edgeSupplier != null : !this.edgeSupplier.equals(other.edgeSupplier)) {
            return false;
        }
        return !(this.graph == null ? other.graph != null : !this.graph.equals(other.graph));
    }

    public Supplier<Node> getVertexSupplier() {
        return NodeFactory::createBlankNode;
    }

    public Node addVertex() {
        Node result = Optional.ofNullable(this.getVertexSupplier()).orElseThrow(UnsupportedOperationException::new).get();
        this.addVertex(result);
        return result;
    }
}

