/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.jena.jgrapht.EdgeFactoryJenaModel;
import org.aksw.commons.jena.jgrapht.IntrusiveEdgesSpecificsJenaModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;

public class PseudoGraphJenaModel
implements Graph<RDFNode, Statement> {
    protected Model model;
    protected GraphType graphType;
    protected Property confinementProperty;
    protected EdgeFactoryJenaModel edgeSupplier;
    protected IntrusiveEdgesSpecifics<RDFNode, Statement> intrusiveEdgesSpecifics;

    public PseudoGraphJenaModel(Model model) {
        this(model, (GraphType)DefaultGraphType.directedPseudograph());
    }

    public PseudoGraphJenaModel(Model model, Property confinementProperty) {
        this(model, (GraphType)DefaultGraphType.directedPseudograph(), confinementProperty);
    }

    public PseudoGraphJenaModel(Model model, GraphType graphType) {
        this(model, graphType, null);
    }

    public PseudoGraphJenaModel(Model model, GraphType graphType, Property confinementProperty) {
        this(model, graphType, confinementProperty, confinementProperty);
    }

    public PseudoGraphJenaModel(Model model, GraphType graphType, Property confinementProperty, Property insertProperty) {
        this.model = model;
        this.graphType = graphType;
        this.confinementProperty = confinementProperty;
        this.edgeSupplier = new EdgeFactoryJenaModel(model, insertProperty);
        this.intrusiveEdgesSpecifics = new IntrusiveEdgesSpecificsJenaModel(model, confinementProperty);
    }

    public Set<Statement> getAllEdges(RDFNode sourceVertex, RDFNode targetVertex) {
        Set result = this.listStatements(sourceVertex, this.confinementProperty, targetVertex).toSet();
        return result;
    }

    public Statement getEdge(RDFNode sourceVertex, RDFNode targetVertex) {
        Set<Statement> edges = this.getAllEdges(sourceVertex, targetVertex);
        Statement result = edges.iterator().next();
        return result;
    }

    public Supplier<Statement> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public Statement addEdge(RDFNode sourceVertex, RDFNode targetVertex) {
        Statement result = this.edgeSupplier.createEdge(sourceVertex, targetVertex);
        this.model.add(result);
        return result;
    }

    public boolean addEdge(RDFNode sourceVertex, RDFNode targetVertex, Statement e) {
        boolean result;
        boolean isValid;
        boolean bl = isValid = e.getSubject().equals((Object)sourceVertex) && e.getObject().equals(targetVertex);
        if (!isValid) {
            throw new RuntimeException("Source and/or target vertex does not match those of the triple: " + String.valueOf(sourceVertex) + " " + String.valueOf(targetVertex) + " " + String.valueOf(e));
        }
        if (this.confinementProperty != null && !e.getPredicate().equals((Object)this.confinementProperty)) {
            throw new RuntimeException("Graph is confined to predicate " + String.valueOf(this.confinementProperty) + " therefore cannot add edge with predicate " + String.valueOf(e));
        }
        boolean bl2 = result = !this.model.contains(e);
        if (result) {
            this.model.add(e);
        }
        return result;
    }

    public boolean addVertex(RDFNode v) {
        boolean result = !this.containsVertex(v);
        return result;
    }

    public boolean containsEdge(RDFNode sourceVertex, RDFNode targetVertex) {
        boolean result = sourceVertex != null && sourceVertex.isResource() && this.model.contains(sourceVertex.asResource(), this.confinementProperty, targetVertex);
        return result;
    }

    public boolean containsEdge(Statement e) {
        boolean result = this.model.contains(e);
        return result;
    }

    public boolean containsVertex(RDFNode v) {
        boolean result = v != null && v.isResource() && this.model.contains(v.asResource(), null, null) || this.model.contains(null, null, v);
        return result;
    }

    public Set<Statement> edgeSet() {
        Set result = this.listStatements(null, this.confinementProperty, null).toSet();
        return result;
    }

    public int degreeOf(RDFNode vertex) {
        return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
    }

    public Set<Statement> edgesOf(RDFNode vertex) {
        Set result = this.listStatements(vertex, this.confinementProperty, null).andThen((Iterator)this.listStatements(null, this.confinementProperty, vertex)).toSet();
        return result;
    }

    public boolean removeAllEdges(Collection<? extends Statement> edges) {
        boolean result = edges.stream().map(this::removeEdge).reduce(false, (r, e) -> r != false || e != false);
        return result;
    }

    public Set<Statement> removeAllEdges(RDFNode sourceVertex, RDFNode targetVertex) {
        Set result = this.listStatements(sourceVertex, this.confinementProperty, targetVertex).toSet();
        result.forEach(arg_0 -> ((Model)this.model).remove(arg_0));
        return result;
    }

    public boolean removeAllVertices(Collection<? extends RDFNode> vertices) {
        boolean result = vertices.stream().map(this::removeVertex).reduce(false, (r, v) -> r != false || v != false);
        return result;
    }

    public Statement removeEdge(RDFNode sourceVertex, RDFNode targetVertex) {
        Statement result = this.getEdge(sourceVertex, targetVertex);
        if (result != null) {
            this.model.remove(result);
        }
        return result;
    }

    public boolean removeEdge(Statement e) {
        boolean result = this.model.contains(e);
        if (result) {
            this.model.remove(e);
        }
        return result;
    }

    public boolean removeVertex(RDFNode v) {
        boolean result = this.model.containsResource(v);
        if (v != null && v.isResource()) {
            this.model.remove(v.asResource(), this.confinementProperty, null);
        }
        this.model.remove(null, this.confinementProperty, v);
        return result;
    }

    public Set<RDFNode> vertexSet() {
        LinkedHashSet<RDFNode> result = new LinkedHashSet<RDFNode>();
        this.model.listStatements(null, this.confinementProperty, null).forEachRemaining(stmt -> {
            result.add((RDFNode)stmt.getSubject());
            result.add(stmt.getObject());
        });
        return result;
    }

    public RDFNode getEdgeSource(Statement e) {
        return e.getSubject();
    }

    public RDFNode getEdgeTarget(Statement e) {
        return e.getObject();
    }

    public GraphType getType() {
        return this.graphType;
    }

    public double getEdgeWeight(Statement e) {
        return 1.0;
    }

    public int inDegreeOf(RDFNode vertex) {
        int result = this.incomingEdgesOf(vertex).size();
        return result;
    }

    public Set<Statement> incomingEdgesOf(RDFNode vertex) {
        Set result = this.listStatements(null, this.confinementProperty, vertex).toSet();
        return result;
    }

    public int outDegreeOf(RDFNode vertex) {
        int result = this.outgoingEdgesOf(vertex).size();
        return result;
    }

    public Set<Statement> outgoingEdgesOf(RDFNode vertex) {
        Set result = this.listStatements(vertex, this.confinementProperty, null).toSet();
        return result;
    }

    public void setEdgeWeight(Statement statement, double weight) {
        throw new UnsupportedOperationException("RDF graph is not weighted");
    }

    public StmtIterator listStatements(RDFNode sourceVertex, Property property, RDFNode targetVertex) {
        StmtIteratorImpl result = null;
        if (sourceVertex == null || sourceVertex.isResource()) {
            Resource s = sourceVertex == null ? null : sourceVertex.asResource();
            result = this.model.listStatements(s, property, targetVertex);
        } else {
            result = new StmtIteratorImpl(Collections.emptySet().iterator());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.confinementProperty == null ? 0 : this.confinementProperty.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoGraphJenaModel other = (PseudoGraphJenaModel)obj;
        if (this.model == null ? other.model != null : !this.model.equals((Object)other.model)) {
            return false;
        }
        return !(this.confinementProperty == null ? other.confinementProperty != null : !this.confinementProperty.equals((Object)other.confinementProperty));
    }

    public String toString() {
        return "PseudoGraphJena [model=" + String.valueOf(this.model) + ", predicate=" + String.valueOf(this.confinementProperty) + "]";
    }

    public Supplier<RDFNode> getVertexSupplier() {
        return () -> ((Model)this.model).createResource();
    }

    public RDFNode addVertex() {
        RDFNode result = Optional.ofNullable(this.getVertexSupplier()).orElseThrow(UnsupportedOperationException::new).get();
        this.addVertex(result);
        return result;
    }
}

