/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;

public class SetOfStatementsFromModel
extends AbstractSet<Statement> {
    protected Model model;
    protected Property confinementProperty;

    public SetOfStatementsFromModel(Model model, Property confinementProperty) {
        this.model = model;
        this.confinementProperty = confinementProperty;
    }

    @Override
    public boolean add(Statement e) {
        boolean tmp = this.model.contains(e);
        if (!tmp) {
            this.model.add(e);
        }
        boolean result = !tmp;
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Statement stmt;
        boolean result = false;
        if (o instanceof Statement && (result = this.model.contains(stmt = (Statement)o))) {
            this.model.remove(stmt);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = o instanceof Statement ? this.model.contains((Statement)o) : false;
        return result;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.model.listStatements(null, this.confinementProperty, (RDFNode)null);
    }

    @Override
    public int size() {
        int result = Iterators.size((Iterator)this.model.listStatements(null, this.confinementProperty, (RDFNode)null));
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.confinementProperty == null ? 0 : this.confinementProperty.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOfStatementsFromModel other = (SetOfStatementsFromModel)obj;
        if (this.confinementProperty == null ? other.confinementProperty != null : !this.confinementProperty.equals(other.confinementProperty)) {
            return false;
        }
        return !(this.model == null ? other.model != null : !this.model.equals((Object)other.model));
    }
}

