/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class SetOfTriplesFromGraph
extends AbstractSet<Triple> {
    protected Graph graph;
    protected Node confinementPredicate;

    public SetOfTriplesFromGraph(Graph graph, Node confinementProperty) {
        this.graph = graph;
        this.confinementPredicate = confinementProperty;
    }

    @Override
    public boolean add(Triple e) {
        boolean tmp = this.graph.contains(e);
        if (!tmp) {
            this.graph.add(e);
        }
        boolean result = !tmp;
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Triple triple;
        boolean result = false;
        if (o instanceof Triple && (result = this.graph.contains(triple = (Triple)o))) {
            this.graph.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = o instanceof Triple ? this.graph.contains((Triple)o) : false;
        return result;
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.graph.find(null, this.confinementPredicate, null);
    }

    @Override
    public int size() {
        int result = Iterators.size((Iterator)this.graph.find(null, this.confinementPredicate, null));
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.confinementPredicate == null ? 0 : this.confinementPredicate.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOfTriplesFromGraph other = (SetOfTriplesFromGraph)obj;
        if (this.confinementPredicate == null ? other.confinementPredicate != null : !this.confinementPredicate.equals((Object)other.confinementPredicate)) {
            return false;
        }
        return !(this.graph == null ? other.graph != null : !this.graph.equals(other.graph));
    }
}

