/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jena.jgrapht;

import java.util.Set;
import org.aksw.commons.jena.jgrapht.SetOfTriplesFromGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;

public class IntrusiveEdgesSpecificsJenaGraph
implements IntrusiveEdgesSpecifics<Node, Triple> {
    private static final long serialVersionUID = 6058434931932958438L;
    protected Graph graph;
    protected Node confinementPredicate;

    public IntrusiveEdgesSpecificsJenaGraph(Graph graph, Node confinementPredicate) {
        this.graph = graph;
        this.confinementPredicate = confinementPredicate;
    }

    public Node getEdgeSource(Triple e) {
        return e.getSubject();
    }

    public Node getEdgeTarget(Triple e) {
        return e.getObject();
    }

    public boolean add(Triple e, Node sourceVertex, Node targetVertex) {
        Triple stmt = Triple.create((Node)sourceVertex, (Node)this.confinementPredicate, (Node)targetVertex);
        boolean tmp = this.graph.contains(stmt);
        if (!tmp) {
            this.graph.add(stmt);
        }
        boolean result = !tmp;
        return result;
    }

    public boolean containsEdge(Triple e) {
        boolean result = this.graph.contains(e);
        return result;
    }

    public Set<Triple> getEdgeSet() {
        return new SetOfTriplesFromGraph(this.graph, this.confinementPredicate);
    }

    public void remove(Triple e) {
        this.graph.remove(e.getSubject(), e.getPredicate(), e.getObject());
    }

    public double getEdgeWeight(Triple e) {
        return 1.0;
    }

    public void setEdgeWeight(Triple e, double weight) {
        if (weight != 1.0) {
            throw new UnsupportedOperationException();
        }
    }
}

