/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class GenericNodeSerializerCustom
extends Serializer<Node> {
    public static final int TYPE_MASK = 112;
    public static final int TYPE_IRI = 16;
    public static final int TYPE_BNODE = 32;
    public static final int TYPE_LITERAL = 48;
    public static final int TYPE_VAR = 64;
    public static final int TYPE_TRIPLE = 80;
    public static final int SUBTYPE_MASK = 3;
    public static final int LITERAL_HAS_LANG = 1;
    public static final int LITERAL_HAS_DTYPE = 2;
    public static final int ABBREV_VALUE = 8;
    public static final int ABBREV_DTYPE = 4;
    public static BiMap<String, String> prefixToIri = HashBiMap.create();
    protected TypeMapper typeMapper;

    static {
        prefixToIri.put((Object)"a", (Object)RDF.type.getURI());
        prefixToIri.put((Object)"d", (Object)Quad.defaultGraphIRI.getURI());
        prefixToIri.put((Object)"g", (Object)Quad.defaultGraphNodeGenerated.getURI());
        prefixToIri.put((Object)"x", (Object)"http://www.w3.org/2001/XMLSchema#");
        prefixToIri.put((Object)"r", (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixToIri.put((Object)"s", (Object)"http://www.w3.org/2000/01/rdf-schema#");
        prefixToIri.put((Object)"o", (Object)"http://www.w3.org/2002/07/owl#");
    }

    public static String getPossibleKey(String iriString) {
        int n = iriString.length();
        int i = n - 1;
        block3: while (i >= 0) {
            char c = iriString.charAt(i);
            switch (c) {
                case '#': 
                case '.': 
                case '/': 
                case ':': {
                    break block3;
                }
                default: {
                    --i;
                }
            }
        }
        String result = i >= 0 ? iriString.substring(0, i + 1) : null;
        return result;
    }

    public static String encode(Map<String, String> iriToPrefix, String iri) {
        String prefix;
        String key;
        Object result = iriToPrefix.get(iri);
        if (result == null && (key = GenericNodeSerializerCustom.getPossibleKey(iri)) != null && (prefix = iriToPrefix.get(key)) != null) {
            result = prefix + ":" + iri.substring(key.length());
        }
        return result;
    }

    public static String decode(Map<String, String> prefixToIri, String curie) {
        Object result;
        int idx = curie.indexOf(58);
        if (idx < 0) {
            result = prefixToIri.get(curie);
        } else {
            String prefix = curie.substring(0, idx);
            String iri = prefixToIri.get(prefix);
            result = iri + curie.substring(idx + 1);
        }
        return result;
    }

    public GenericNodeSerializerCustom() {
        this(TypeMapper.getInstance());
    }

    public GenericNodeSerializerCustom(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void write(Kryo kryo, Output output, Node node) {
        if (node.isURI()) {
            String uri = node.getURI();
            String curie = GenericNodeSerializerCustom.encode((Map<String, String>)prefixToIri.inverse(), uri);
            if (curie != null) {
                output.writeByte(24);
                output.writeString(curie);
            } else {
                output.writeByte(16);
                output.writeString(uri);
            }
        } else if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String lang = node.getLiteralLanguage();
            String dt = node.getLiteralDatatypeURI();
            if (lang != null && !lang.isEmpty()) {
                output.writeByte(49);
                output.writeString(lex);
                output.writeString(lang);
            } else if (dt != null && !dt.isEmpty() && !dt.equals(XSD.xstring.getURI())) {
                String dtCurie = GenericNodeSerializerCustom.encode((Map<String, String>)prefixToIri.inverse(), dt);
                if (dtCurie != null) {
                    output.writeByte(54);
                    output.writeString(lex);
                    output.writeString(dtCurie);
                } else {
                    output.writeByte(50);
                    output.writeString(lex);
                    output.writeString(dt);
                }
            } else {
                output.writeByte(48);
                output.writeString(lex);
            }
        } else if (node.isBlank()) {
            output.writeByte(32);
            output.writeString(node.getBlankNodeLabel());
        } else if (node.isVariable()) {
            output.writeByte(64);
            output.writeString(node.getName());
        } else if (node.isNodeTriple()) {
            output.writeByte(80);
            kryo.writeObject(output, (Object)node.getTriple());
        } else {
            throw new RuntimeException("Unknown node type: " + String.valueOf(node));
        }
    }

    public Node read(Kryo kryo, Input input, Class<Node> cls) {
        byte type = input.readByte();
        int typeVal = type & 0x70;
        return switch (typeVal) {
            case 16 -> {
                String v1 = input.readString();
                if ((type & 8) != 0) {
                    v1 = GenericNodeSerializerCustom.decode(prefixToIri, v1);
                }
                yield NodeFactory.createURI((String)v1);
            }
            case 48 -> {
                int subTypeVal = type & 3;
                switch (subTypeVal) {
                    case 0: {
                        String v1 = input.readString();
                        yield NodeFactory.createLiteral((String)v1);
                    }
                    case 1: {
                        String v1 = input.readString();
                        String v2 = input.readString();
                        yield NodeFactory.createLiteral((String)v1, (String)v2);
                    }
                    case 2: {
                        String v1 = input.readString();
                        String v2 = input.readString();
                        if ((type & 4) != 0) {
                            v2 = GenericNodeSerializerCustom.decode(prefixToIri, v2);
                        }
                        RDFDatatype dtype = this.typeMapper.getSafeTypeByName(v2);
                        yield NodeFactory.createLiteral((String)v1, (RDFDatatype)dtype);
                    }
                }
                throw new RuntimeException("Unknown literal sub-type: " + subTypeVal);
            }
            case 32 -> {
                String v1 = input.readString();
                yield NodeFactory.createBlankNode((String)v1);
            }
            case 64 -> {
                String v1 = input.readString();
                yield Var.alloc((String)v1);
            }
            case 80 -> {
                Triple t = (Triple)kryo.readObject(input, Triple.class);
                yield NodeFactory.createTripleNode((Triple)t);
            }
            default -> throw new RuntimeException("Unknown node type: " + typeVal);
        };
    }
}

