/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;

public class E_BNodeSerializer
extends Serializer<ExprFunction> {
    public void write(Kryo kryo, Output output, ExprFunction func) {
        Preconditions.checkArgument((boolean)"bnode".equals(func.getFunctionSymbol().getSymbol()), (Object)"Not a E_BNode expression");
        kryo.writeClassAndObject(output, (Object)func.getArgs());
    }

    public ExprFunction read(Kryo kryo, Input input, Class<ExprFunction> type) {
        List args = (List)kryo.readClassAndObject(input);
        int n = args.size();
        Preconditions.checkState((n < 2 ? 1 : 0) != 0, (Object)"E_BNode with more than 1 argument");
        Expr expr = n == 0 ? E_BNode.create() : E_BNode.create((Expr)((Expr)args.get(0)));
        ExprFunction result = (ExprFunction)expr;
        return result;
    }
}

