/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;

public class GenericNodeSerializerViaRiot
extends Serializer<Node> {
    private static final PrefixMap pmap = PrefixMapFactory.create();
    protected ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerWarn;
    protected ParserProfile profile = this.setupInternalParserProfile();
    NodeFormatter nodeFormatter = new NodeFormatterNT();
    IndentedLineBuffer writer = new IndentedLineBuffer();

    public void write(Kryo kryo, Output output, Node obj) {
        this.nodeFormatter.format((AWriter)this.writer, obj);
        output.writeString(this.writer.toString());
        this.writer.clear();
    }

    public Node read(Kryo kryo, Input input, Class<Node> objClass) {
        String s = input.readString();
        Node node = this.parse(s);
        return node;
    }

    public Node parse(String string) {
        Node n;
        Tokenizer tokenizer = TokenizerText.create().errorHandler(this.errorHandler).fromString(string).build();
        if (!tokenizer.hasNext()) {
            n = null;
        } else {
            Token t = tokenizer.next();
            n = this.profile.create(null, t);
        }
        return n;
    }

    protected ParserProfile setupInternalParserProfile() {
        LabelToNode labelToNode = LabelToNode.createUseLabelEncoded();
        FactoryRDF factoryRDF = RiotLib.factoryRDF((LabelToNode)labelToNode);
        IRIxResolver iriXResolver = IRIxResolver.create().noBase().allowRelative(true).build();
        ParserProfileStd result = new ParserProfileStd(factoryRDF, this.errorHandler, iriXResolver, pmap, RIOT.getContext().copy(), true, false);
        return result;
    }

    static {
        pmap.add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        pmap.add("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        pmap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        pmap.add("owl", "http://www.w3.org/2002/07/owl#");
    }
}

