/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFNodeJsonUtils {
    public static final String KEY_NODE = "node";
    public static final String KEY_GRAPH = "graph";

    public static String nodeToStr(Node node) {
        Object result = node.isBlank() ? "_:" + node.getBlankNodeLabel() : NodeFmtLib.strNT((Node)node);
        return result;
    }

    public static Node strToNode(String str) {
        Node result = str.startsWith("_:") ? NodeFactory.createBlankNode((String)str.substring(2)) : RiotLib.parse((String)str);
        return result;
    }

    public static JsonObject toJsonObject(Model model, Gson gson) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)baos, (Model)model, (RDFFormat)RDFFormat.RDFJSON);
        String str = baos.toString();
        JsonObject result = (JsonObject)gson.fromJson(str, JsonObject.class);
        return result;
    }

    public static JsonObject addJsonSerialization(Gson gson, JsonArray out, String name, Model model) {
        JsonObject result = null;
        if (!model.isEmpty()) {
            JsonObject data = RDFNodeJsonUtils.toJsonObject(model, gson);
            result = new JsonObject();
            result.addProperty("name", name);
            result.add("data", (JsonElement)data);
            out.add((JsonElement)result);
        }
        return result;
    }

    public static JsonObject toJsonObject(Dataset dataset, Gson gson) {
        JsonObject result = new JsonObject();
        JsonObject dgJson = RDFNodeJsonUtils.toJsonObject(dataset.getDefaultModel(), gson);
        result.add("defaultGraph", (JsonElement)dgJson);
        JsonArray arr = new JsonArray();
        Iterator it = dataset.listNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            Model m = dataset.getNamedModel(name);
            RDFNodeJsonUtils.addJsonSerialization(gson, arr, name, m);
        }
        if (arr.size() != 0) {
            result.add("namedGraphs", (JsonElement)arr);
        }
        return result;
    }

    public static String toJsonNodeString(RDFNode n, Gson gson) {
        JsonObject jsonNodeLdOject = RDFNodeJsonUtils.toJsonNodeObject(n, gson);
        String result = gson.toJson((JsonElement)jsonNodeLdOject);
        return result;
    }

    public static JsonObject toJsonNodeObject(RDFNode rdfNode, Gson gson) {
        Model model = rdfNode.getModel();
        Node n = rdfNode.asNode();
        String nodeStr = RDFNodeJsonUtils.nodeToStr(n);
        JsonObject modelJson = RDFNodeJsonUtils.toJsonObject(model, gson);
        JsonObject result = new JsonObject();
        result.addProperty(KEY_NODE, nodeStr);
        result.add(KEY_GRAPH, (JsonElement)modelJson);
        return result;
    }

    public static RDFNode toRDFNode(String jsonNodeLdString, Gson gson) {
        JsonObject jsonNodeLd = (JsonObject)gson.fromJson(jsonNodeLdString, JsonObject.class);
        RDFNode result = RDFNodeJsonUtils.toRDFNode(jsonNodeLd);
        return result;
    }

    public static RDFNode toRDFNode(JsonObject jsonNodeLd) {
        String subjectStr = jsonNodeLd.get(KEY_NODE).getAsString();
        Node node = RDFNodeJsonUtils.strToNode(subjectStr);
        String graphStr = jsonNodeLd.get(KEY_GRAPH).toString();
        Model model = RDFNodeJsonUtils.toModel(graphStr);
        RDFNode result = model.asRDFNode(node);
        return result;
    }

    public static Model toModel(String jsonString) {
        Model result = ModelFactory.createDefaultModel();
        RDFParserBuilder.create().fromString(jsonString).labelToNode(SyntaxLabels.createLabelToNodeAsGiven()).lang(Lang.RDFJSON).parse(result);
        return result;
    }

    public static Model toModel(Model result, String jsonString) {
        RDFParserBuilder.create().fromString(jsonString).labelToNode(SyntaxLabels.createLabelToNodeAsGiven()).lang(Lang.RDFJSON).parse(result);
        return result;
    }

    public static Dataset toDataset(String jsonString) {
        Dataset result = DatasetFactory.create();
        RDFNodeJsonUtils.toDataset(result, jsonString);
        return result;
    }

    public static Dataset toDataset(Dataset result, String jsonString) {
        JsonElement nge;
        Gson gson = new Gson();
        JsonObject root = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        JsonElement dge = root.get("defaultGraph");
        if (dge != null) {
            Model m = result.getDefaultModel();
            RDFNodeJsonUtils.toModel(m, dge.toString());
        }
        if ((nge = root.get("namedGraphs")) != null) {
            JsonArray arr = nge.getAsJsonArray();
            for (JsonElement e : arr) {
                JsonObject obj = e.getAsJsonObject();
                String name = obj.get("name").getAsString();
                JsonObject data = obj.get("data").getAsJsonObject();
                Model m = result.getNamedModel(name);
                RDFNodeJsonUtils.toModel(m, data.toString());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        List<RDFNode> rdfNodes = Arrays.asList(ModelFactory.createDefaultModel().createResource().addProperty(RDF.type, (RDFNode)OWL.Class), ModelFactory.createDefaultModel().createResource(RDFS.Resource.getURI()).addProperty(RDF.type, (RDFNode)OWL.Class));
        for (RDFNode r : rdfNodes) {
            String str = RDFNodeJsonUtils.toJsonNodeString(r, new Gson());
            System.out.println(str);
            RDFNode rdfNode = RDFNodeJsonUtils.toRDFNode(str, new Gson());
            RDFDataMgr.write((OutputStream)System.out, (Model)rdfNode.getModel(), (RDFFormat)RDFFormat.TURTLE_PRETTY);
        }
    }
}

