/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.json;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.io.json.RDFNodeJsonUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;

public class TypeAdapterDataset
extends TypeAdapter<Dataset> {
    protected Supplier<Dataset> datasetSupplier;

    public TypeAdapterDataset() {
        this(DatasetFactory::create);
    }

    public TypeAdapterDataset(Supplier<Dataset> datasetSupplier) {
        this.datasetSupplier = datasetSupplier;
    }

    public void write(JsonWriter out, Dataset value) throws IOException {
        JsonObject obj = RDFNodeJsonUtils.toJsonObject(value, new Gson());
        out.value(String.valueOf(obj));
    }

    public Dataset read(JsonReader in) throws IOException {
        String str = in.nextString();
        Dataset result = this.datasetSupplier.get();
        RDFNodeJsonUtils.toDataset(result, str);
        return result;
    }
}

