/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.aksw.jena_sparql_api.io.endpoint.ConcurrentFileEndpoint;
import org.aksw.jena_sparql_api.io.endpoint.HotFile;

public class HotFileFromJava
implements HotFile {
    protected ConcurrentFileEndpoint endpoint;
    protected AutoCloseable cancelAction;

    public HotFileFromJava(ConcurrentFileEndpoint endpoint, AutoCloseable cancelAction) {
        this.endpoint = endpoint;
        this.cancelAction = cancelAction;
    }

    public CompletableFuture<Path> future() {
        return this.endpoint.getIsDone();
    }

    public void abort() throws Exception {
        this.cancelAction.close();
    }

    @Override
    public InputStream newInputStream() throws IOException {
        InputStream result = Channels.newInputStream(this.endpoint.newReadChannel());
        return result;
    }

    public String toString() {
        return "HotFileFromJava [endpoint=" + String.valueOf(this.endpoint) + "]";
    }
}

