/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class GraphFindCache {
    public static final String NS = "https://w3id.org/aksw/jenax#graph.";
    public static final Symbol graphCache = SystemARQ.allocSymbol((String)"https://w3id.org/aksw/jenax#graph.", (String)"cache");
    private Cache<Triple, ReadableChannelSource<Binding[]>> cache;

    public static GraphFindCache get(Context cxt) {
        return (GraphFindCache)cxt.get(graphCache);
    }

    public static GraphFindCache getOrCreate(Context cxt) {
        GraphFindCache result = GraphFindCache.get(cxt);
        return result;
    }

    public static void set(Context cxt, GraphFindCache cache) {
        cxt.put(graphCache, (Object)cache);
    }

    public GraphFindCache(int cacheSize) {
        this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
    }

    public GraphFindCache(Cache<Triple, ReadableChannelSource<Binding[]>> cache) {
        this.cache = cache;
    }

    public Cache<Triple, ReadableChannelSource<Binding[]>> getCache() {
        return this.cache;
    }
}

