/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.endpoint;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.jena_sparql_api.io.endpoint.ConcurrentFileEndpoint;

public class ConcurrentFileReader
implements ReadableByteChannel {
    protected Channel referenceChannel;
    protected SeekableByteChannel currentReadChannel;
    protected Integer pollIntervalInMs;

    public static ConcurrentFileReader create(Path path, Channel writeChannel, Integer pollIntervalInMs) throws IOException {
        SeekableByteChannel currentReadChannel = Files.newByteChannel(path, StandardOpenOption.READ);
        ConcurrentFileReader result = new ConcurrentFileReader(writeChannel, currentReadChannel, pollIntervalInMs);
        return result;
    }

    public ConcurrentFileReader(Channel writeChannel, SeekableByteChannel currentReadChannel, Integer pollIntervalInMs) {
        this.referenceChannel = writeChannel;
        this.currentReadChannel = currentReadChannel;
        this.pollIntervalInMs = pollIntervalInMs;
    }

    @Override
    public boolean isOpen() {
        boolean result = this.currentReadChannel != null || this.currentReadChannel.isOpen();
        return result;
    }

    public boolean isAborted() {
        boolean result = this.referenceChannel instanceof ConcurrentFileEndpoint ? ((ConcurrentFileEndpoint)this.referenceChannel).isAbandoned() : false;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.currentReadChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result;
        while (true) {
            if (this.isAborted()) {
                throw new IOException("The underlying stream has been aborted");
            }
            result = this.currentReadChannel.read(dst);
            if (result != -1 || !this.referenceChannel.isOpen()) break;
            try {
                Channel channel = this.referenceChannel;
                synchronized (channel) {
                    if (this.referenceChannel.isOpen()) {
                        if (this.pollIntervalInMs == null) {
                            this.referenceChannel.wait();
                        } else {
                            Thread.sleep(this.pollIntervalInMs.intValue());
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

