/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rowset.csv;

import java.io.IOException;
import java.util.List;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriter;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterBuilderBase;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterFactory;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class RowSetStreamWriterCSV
implements RowSetStreamWriter {
    public static final RowSetStreamWriterFactory factory = () -> new RowSetStreamWriterBuilderCSV();
    static final String NL = "\r\n";
    static final String headerBytes = "_askResult\r\n";
    static final String yesString = "true";
    static final String noString = "false";
    protected AWriter out;
    protected Context context;
    protected List<Var> vars;

    protected RowSetStreamWriterCSV(AWriter out, List<Var> vars, Context context) {
        this.out = out;
        this.vars = vars;
        this.context = context;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeAskResult(boolean booleanResult) {
        try {
            this.out.write(headerBytes);
            if (booleanResult) {
                this.out.write(yesString);
            } else {
                this.out.write(noString);
            }
            this.out.write(NL);
        }
        finally {
            this.out.flush();
        }
    }

    @Override
    public void writeHeader() throws IOException {
        String sep = null;
        for (Var var : this.vars) {
            String v = var.getVarName();
            if (sep != null) {
                this.out.write(sep);
            } else {
                sep = ",";
            }
            this.out.write(RowSetStreamWriterCSV.csvSafe(v));
        }
        this.out.write(NL);
    }

    @Override
    public void beginBindings() {
    }

    @Override
    public void writeBindingSeparator() {
    }

    @Override
    public void endBindings() {
    }

    @Override
    public void writeFooter() {
    }

    @Override
    public void writeBinding(Binding binding) {
        String sep = null;
        for (Var v : this.vars) {
            if (sep != null) {
                this.out.write(sep);
            }
            sep = ",";
            Node n = binding.get(v);
            if (n == null) continue;
            RowSetStreamWriterCSV.output(this.out, n);
        }
        this.out.write(NL);
    }

    private static void output(AWriter w, Node n) {
        Object str = "?";
        if (n.isLiteral()) {
            str = n.getLiteralLexicalForm();
        } else if (n.isURI()) {
            str = n.getURI();
        } else if (n.isBlank()) {
            str = "_:" + n.getBlankNodeLabel();
        }
        str = RowSetStreamWriterCSV.csvSafe((String)str);
        w.write((String)str);
        w.flush();
    }

    protected static String csvSafe(String str) {
        if (((String)str).contains("\"") || ((String)str).contains(",") || ((String)str).contains("\r") || ((String)str).contains("\n")) {
            str = "\"" + ((String)str).replaceAll("\"", "\"\"") + "\"";
        } else if (((String)str).isEmpty()) {
            str = "\"\"";
        }
        return str;
    }

    public static class RowSetStreamWriterBuilderCSV
    extends RowSetStreamWriterBuilderBase {
        @Override
        protected RowSetStreamWriter buildActual() {
            AWriter awriter = this.getAWriter();
            return new RowSetStreamWriterCSV(awriter, this.vars, this.context);
        }
    }
}

