/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.io.binseach.BinarySearchOnSortedFile;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jenax.arq.util.graph.GraphFindRaw;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.lang.IteratorParsers;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFromPrefixMatcher
extends GraphBase
implements GraphFindRaw {
    private static final Logger logger = LoggerFactory.getLogger(GraphFromPrefixMatcher.class);
    protected BinarySearcher binarySearcher;

    public GraphFromPrefixMatcher(BinarySearcher binarySearcher) {
        this.binarySearcher = binarySearcher;
    }

    public static Iterator<Triple> createBaseIterator(BinarySearcher binarySearcher, Triple triplePattern) {
        IteratorCloseable result;
        String prefix = GraphFromPrefixMatcher.derivePrefix(triplePattern);
        if (prefix == null) {
            result = Collections.emptyIterator();
        } else {
            InputStream in;
            try {
                in = binarySearcher.search(prefix);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            result = Iter.onCloseIO((Iterator)IteratorParsers.createIteratorNTriples((InputStream)in, (ParserProfile)RDFDataMgrRx.dftProfile()), in::close);
        }
        return result;
    }

    public ExtendedIterator<Triple> findRaw(Triple triplePattern) {
        return WrappedIterator.create(GraphFromPrefixMatcher.createBaseIterator(this.binarySearcher, triplePattern));
    }

    protected ExtendedIterator<Triple> graphBaseFindCore(Triple triplePattern) throws IOException {
        Iterator it = Iter.filter(GraphFromPrefixMatcher.createBaseIterator(this.binarySearcher, triplePattern), arg_0 -> ((Triple)triplePattern).matches(arg_0));
        ExtendedIterator result = WrappedIterator.create((Iterator)it);
        return result;
    }

    public static String derivePrefix(Triple t) {
        String tmp;
        Object result = GraphFromPrefixMatcher.derivePrefix(t.getSubject());
        if (result != null && !"".equals(result) && (tmp = GraphFromPrefixMatcher.derivePrefix(t.getPredicate())) != null && !"".equals(tmp)) {
            result = (String)result + " " + tmp;
        }
        return result;
    }

    public static String derivePrefix(Node s) {
        Object prefix = s.equals((Object)Node.ANY) || s.isVariable() ? "" : (s.isBlank() ? "_:" + s.getBlankNodeLabel() : (s.isURI() ? "<" + s.getURI() + ">" : null));
        return prefix;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
        ExtendedIterator<Triple> result;
        try {
            result = this.graphBaseFindCore(triplePattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void close() {
        try {
            this.binarySearcher.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        Object queryStr;
        JenaSystem.init();
        SparqlStmtParserImpl parser = SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (PrefixMapping)DefaultPrefixes.get(), (boolean)false);
        Path path = Paths.get("/home/raven/Projects/Data/LSQ/deleteme.sorted.nt", new String[0]);
        GraphFromPrefixMatcher graph = new GraphFromPrefixMatcher((BinarySearcher)BinarySearchOnSortedFile.create((Path)path));
        Model m = ModelFactory.createModelForGraph((Graph)graph);
        Iterator itSubject = Files.lines(Paths.get("/home/raven/Projects/Data/LSQ/subjects.shuffled.txt", new String[0])).iterator();
        Stopwatch stopwatch = Stopwatch.createStarted();
        int i = 0;
        while (itSubject.hasNext()) {
            if (i % 100 == 0) {
                System.out.println(i);
            }
            ++i;
            String s = (String)itSubject.next();
            queryStr = "SELECT * { " + s + " ?p ?o }";
            QueryExecution qe = QueryExecutionFactory.create((String)queryStr, (Model)m);
            try {
                long numResults = ResultSetFormatter.consume((ResultSet)qe.execSelect());
                if (numResults <= 0L) continue;
                int n = 5;
            }
            finally {
                if (qe == null) continue;
                qe.close();
            }
        }
        System.out.println("Processed items in " + (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) * 0.001 + " seconds");
        queryStr = ((SparqlStmt)parser.apply("SELECT *\n           {\n             # TODO Allocate some URI based on the dataset id\n             BIND(BNODE() AS ?report)\n             { SELECT ?p (COUNT(*) AS ?numTriples) (COUNT(DISTINCT ?s) AS ?numUniqS) (COUNT(DISTINCT ?o) AS ?numUniqO) {\n               ?s ?p ?o\n             } GROUP BY ?p }\n           }")).toString();
    }
}

