/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoder;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoderGzip;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoderLbZip;

public class PathCoderRegistry {
    protected static PathCoderRegistry INSTANCE = null;
    protected Map<String, PathCoder> coders = new LinkedHashMap<String, PathCoder>();

    public static PathCoderRegistry get() {
        if (INSTANCE == null) {
            INSTANCE = new PathCoderRegistry();
            PathCoderRegistry.INSTANCE.coders.put("bzip2", new PathCoderLbZip());
            PathCoderRegistry.INSTANCE.coders.put("gzip", new PathCoderGzip());
        }
        return INSTANCE;
    }

    public PathCoder getCoder(String name) {
        return this.coders.get(name);
    }

    public Set<String> getCoderNames() {
        return Collections.unmodifiableSet(this.coders.keySet());
    }
}

