/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.utils;

import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.aksw.commons.io.process.util.SimpleProcessExecutor;

public abstract class AbstractSystemService
extends AbstractIdleService {
    protected Duration healthCheckInterval = Duration.ofSeconds(3L);
    protected transient Process process;
    protected Consumer<String> outputSink;
    protected Thread shutdownHookThread = new Thread(() -> {
        System.err.println("Shutdown hook: terminating virtuoso process");
        if (this.isRunning()) {
            this.stopAsync();
            try {
                this.awaitTerminated(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    });

    public Consumer<String> getOutputSink() {
        return this.outputSink;
    }

    public AbstractSystemService setOutputSink(Consumer<String> outputSink) {
        this.outputSink = outputSink;
        return this;
    }

    public Duration getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public AbstractSystemService setHealthCheckInterval(Duration healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
        return this;
    }

    public abstract boolean performHealthCheck();

    protected abstract ProcessBuilder prepareProcessBuilder();

    protected void startUp() throws IOException, InterruptedException {
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        ProcessBuilder pb = this.prepareProcessBuilder();
        this.process = SimpleProcessExecutor.wrap((ProcessBuilder)pb).setService(true).setOutputSink(x -> {
            if (this.outputSink != null) {
                this.outputSink.accept((String)x);
            }
        }).execute();
        try {
            boolean r = false;
            while (this.process.isAlive()) {
                long millis = this.healthCheckInterval.toMillis();
                Thread.sleep(millis);
                r = this.performHealthCheck();
                if (!r) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void shutDown() {
        this.process.destroy();
        try {
            while (this.process.isAlive()) {
                long millis = this.healthCheckInterval.toMillis();
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.process = null;
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }
}

