/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.endpoint;

import io.reactivex.rxjava3.core.Single;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.aksw.commons.io.endpoint.FileCreation;
import org.aksw.jena_sparql_api.io.endpoint.Destination;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFromFile;
import org.aksw.jena_sparql_api.io.endpoint.FilterConfig;
import org.aksw.jena_sparql_api.io.endpoint.FilterEngine;
import org.aksw.jena_sparql_api.io.endpoint.HotFile;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplier;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplierBasic;

public class DestinationFromFileCreation
implements Destination {
    protected Single<? extends FileCreation> fileCreation;
    protected Path fileBeingCreated;

    public DestinationFromFileCreation(Path fileBeingCreated, Single<? extends FileCreation> fileCreation) {
        this.fileBeingCreated = fileBeingCreated;
        this.fileCreation = fileCreation.cache();
    }

    @Override
    public void cancelCreation() {
        throw new RuntimeException("Not implemented yet");
    }

    public Single<? extends FileCreation> getFileCreation() {
        return this.fileCreation;
    }

    public Path getFileBeingCreated() {
        return this.fileBeingCreated;
    }

    @Override
    public FilterConfig transferTo(FilterEngine engine) {
        return engine.forInput(this);
    }

    @Override
    public Single<InputStreamSupplier> prepareStream() {
        return this.fileCreation.flatMap(fc -> {
            Single r;
            if (fc instanceof HotFile) {
                HotFile hotFile = (HotFile)fc;
                r = Single.just((Object)InputStreamSupplierBasic.wrap(hotFile::newInputStream));
            } else {
                r = Single.fromFuture((Future)fc.future()).map(path -> (InputStreamSupplier)((Object)Files.newInputStream(path, StandardOpenOption.READ)));
            }
            return r;
        });
    }

    @Override
    public Single<DestinationFromFile> materialize(Supplier<Path> preferredPathCallback) {
        FileCreation tmp = (FileCreation)this.fileCreation.blockingGet();
        return Single.fromFuture((Future)tmp.future()).map(x -> new DestinationFromFile((Path)x));
    }

    @Override
    public String getCreationStatus() {
        return null;
    }
}

