/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.collections.CloseableIterator;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannelSources;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.slice.SliceInMemoryCache;
import org.aksw.jena_sparql_api.io.binseach.GraphFindCache;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class GraphCacheStreaming {
    protected static ExecutorService globalExecutorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()));

    public static QueryIterator cache(GraphFindCache cache, Triple lookupPattern, Function<Triple, QueryIterator> itSupp) {
        CloseableIterator cit;
        ReadableChannelSource cachedSource = (ReadableChannelSource)cache.getCache().get((Object)lookupPattern, lp -> {
            Supplier<Stream> bindingStreamFactory = () -> {
                QueryIterator qIter = (QueryIterator)itSupp.apply((Triple)lp);
                Stream stream = (Stream)Streams.stream((Iterator)qIter).onClose(() -> ((QueryIterator)qIter).close());
                return stream;
            };
            ReadableChannelSource source = ReadableChannelSources.ofStreamFactory(bindingStreamFactory);
            AdvancedRangeCacheImpl r = AdvancedRangeCacheImpl.newBuilder().setDataSource(source).setWorkerBulkSize(2).setSlice(SliceInMemoryCache.create((ArrayOps)source.getArrayOps(), (int)1024, (int)1000)).setMaxReadAheadItemCount(0).setRequestLimit(Long.MAX_VALUE).setTerminationDelay(Duration.ofSeconds(180L)).setExecutorService(globalExecutorService).build();
            return r;
        });
        try {
            cit = ReadableChannels.newIterator((ReadableChannel)cachedSource.newReadableChannel(), (int)1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        QueryIterator result = QueryIterPlainWrapper.create((Iterator)Iter.onClose((Iterator)cit, () -> ((CloseableIterator)cit).close()));
        return result;
    }
}

