/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.conjure.entity.utils;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;
import org.aksw.commons.io.process.util.SimpleProcessExecutor;
import org.aksw.jena_sparql_api.conjure.entity.utils.PathCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathCoderSysBase
implements PathCoder {
    private static final Logger logger = LoggerFactory.getLogger(PathCoderSysBase.class);

    protected abstract String[] buildCheckCmd();

    protected abstract String[] buildDecodeCmd(Path var1);

    protected abstract String[] buildEncodeCmd(Path var1);

    @Override
    public boolean cmdExists() {
        boolean result;
        String[] cmd = this.buildCheckCmd();
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        try {
            logger.trace("Checking availability of system command such as 'lbzip2'");
            Process p = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder).setOutputSink(arg_0 -> ((Logger)logger).trace(arg_0)).execute();
            int exitValue = p.exitValue();
            result = exitValue == 0;
        }
        catch (Exception e) {
            logger.debug("System command 'lbzip2' not available", (Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    public Single<Integer> decode(Path input, Path output) {
        return this.run(input, output, this::buildDecodeCmd);
    }

    @Override
    public Single<Integer> encode(Path input, Path output) {
        return this.run(input, output, this::buildEncodeCmd);
    }

    public Single<Integer> run(Path input, Path output, Function<Path, String[]> buildCmd) {
        Single result;
        String[] cmd = buildCmd.apply(input);
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        File outFile = output.toFile();
        processBuilder.redirectOutput(outFile);
        SimpleProcessExecutor x = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder);
        try {
            result = x.executeFuture().subscribeOn(Schedulers.io());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

