/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.endpoint;

import com.google.common.io.ByteSource;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.io.endpoint.Destination;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFromFile;
import org.aksw.jena_sparql_api.io.endpoint.FilterConfig;
import org.aksw.jena_sparql_api.io.endpoint.FilterEngine;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplier;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplierBasic;

public class DestinationFromByteSource
implements Destination {
    protected ByteSource byteSource;

    public DestinationFromByteSource(ByteSource byteSource) {
        this.byteSource = byteSource;
    }

    @Override
    public Single<InputStreamSupplier> prepareStream() {
        return Single.just((Object)InputStreamSupplierBasic.wrap(() -> ((ByteSource)this.byteSource).openStream()));
    }

    @Override
    public FilterConfig transferTo(FilterEngine engine) {
        return engine.forInput(InputStreamSupplierBasic.wrap(() -> ((ByteSource)this.byteSource).openStream()));
    }

    @Override
    public Single<DestinationFromFile> materialize(Supplier<Path> preferredPathCallback) throws IOException {
        Path path = preferredPathCallback.get();
        if (path == null) {
            path = Files.createTempFile("tmp", "suffix", new FileAttribute[0]);
        }
        Files.copy(this.byteSource.openStream(), path, new CopyOption[0]);
        return Single.just((Object)new DestinationFromFile(path));
    }

    @Override
    public String getCreationStatus() {
        return null;
    }
}

