/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ReadableByteChannelFromBlockingQueue
implements ReadableByteChannel {
    protected static final ByteBuffer POISON = ByteBuffer.wrap(new byte[0]);
    protected BlockingQueue<ByteBuffer> clientQueue = new LinkedBlockingQueue<ByteBuffer>(32);
    protected ByteBuffer currentBuffer;
    protected Throwable abortException = null;
    protected boolean isOpen = true;
    protected Runnable closeAction;

    public ReadableByteChannelFromBlockingQueue() {
    }

    public ReadableByteChannelFromBlockingQueue(Runnable closeAction) {
        this.closeAction = closeAction;
    }

    public boolean isComplete() {
        return this.currentBuffer == POISON;
    }

    public void complete() {
        this.put(POISON);
    }

    public void put(ByteBuffer bodyBuffer) {
        try {
            this.clientQueue.put(bodyBuffer);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
        this.isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public int read(ByteBuffer dst) {
        int toRead;
        int result = 0;
        for (int remaining = dst.remaining(); remaining > 0; remaining -= toRead) {
            int available;
            int n = available = this.currentBuffer == null ? 0 : this.currentBuffer.remaining();
            if (available == 0) {
                if (this.currentBuffer == POISON) {
                    result = -1;
                    break;
                }
                try {
                    this.currentBuffer = this.clientQueue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.currentBuffer == POISON) break;
            }
            toRead = Math.min(remaining, available);
            int off = this.currentBuffer.position();
            int newOff = off + toRead;
            ByteBuffer tmp = this.currentBuffer.duplicate();
            ((Buffer)tmp).limit(newOff);
            dst.put(tmp);
            this.currentBuffer.position(newOff);
            result += toRead;
        }
        return result;
    }
}

