/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Iterator;
import org.aksw.jena_sparql_api.rx.GraphFactoryEx;
import org.aksw.jena_sparql_api.rx.query_flow.QueryFlowOps;
import org.aksw.jenax.sparql.rx.op.GraphOpsRx;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphFromSubjectCache
extends GraphBase {
    protected Graph delegate;
    protected Cache<Node, Graph> subjectCache;

    public GraphFromSubjectCache(Graph delegate) {
        this(delegate, (Cache<Node, Graph>)CacheBuilder.newBuilder().recordStats().maximumSize(1000L).concurrencyLevel(1).build());
    }

    public GraphFromSubjectCache(Graph delegate, Cache<Node, Graph> cache) {
        this.delegate = delegate;
        this.subjectCache = cache;
    }

    public Cache<Node, Graph> getSubjectCache() {
        return this.subjectCache;
    }

    protected Graph loadGraph(Node s) {
        Graph result = (Graph)QueryFlowOps.createFlowableFromGraph((Graph)this.delegate, (Triple)Triple.create((Node)s, (Node)Node.ANY, (Node)Node.ANY)).compose(GraphOpsRx.graphFromConsecutiveTriples(Triple::getSubject, GraphFactory::createDefaultGraph)).blockingFirst((Object)Graph.emptyGraph);
        System.err.println("Cache miss for " + String.valueOf(s) + "; loaded " + result.size() + " triples - cache size " + this.subjectCache.size());
        return result;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
        Flowable graphFlow;
        Node s = triplePattern.getSubject();
        if (s.isConcrete()) {
            Graph g2;
            try {
                g2 = (Graph)this.subjectCache.get((Object)s, () -> this.loadGraph(s));
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            graphFlow = g2 == null ? Flowable.empty() : Flowable.just((Object)g2);
        } else {
            Triple surrogatePattern = Triple.create((Node)triplePattern.getSubject(), (Node)Node.ANY, (Node)Node.ANY);
            graphFlow = QueryFlowOps.createFlowableFromGraph((Graph)this.delegate, (Triple)surrogatePattern).subscribeOn(Schedulers.io()).compose(GraphOpsRx.groupConsecutiveTriplesRaw(Triple::getSubject, GraphFactoryEx::createInsertOrderPreservingGraph)).map(e -> {
                Node key = (Node)e.getKey();
                Graph g = (Graph)e.getValue();
                this.subjectCache.put((Object)key, (Object)g);
                return (Graph)e.getValue();
            });
        }
        Flowable resultFlow = graphFlow.flatMap(g -> QueryFlowOps.createFlowableFromGraph((Graph)g, (Triple)triplePattern).filter(candidate -> {
            boolean r = triplePattern.matches(candidate);
            return r;
        }));
        Iterator itTriples = resultFlow.blockingIterable(1).iterator();
        ExtendedIterator result = WrappedIterator.create((Iterator)Iter.onClose(itTriples, () -> ((Disposable)itTriples).dispose()));
        return result;
    }

    public boolean isClosed() {
        boolean result = this.delegate.isClosed();
        return result;
    }

    public void close() {
        this.delegate.close();
    }
}

