/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rowset.core;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterFactory;
import org.aksw.jenax.io.rowset.csv.RowSetStreamWriterCSV;
import org.aksw.jenax.io.rowset.csv.RowSetStreamWriterTSV;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;

public class RowSetStreamWriterRegistry {
    private static Map<Lang, RowSetStreamWriterFactory> registry = new ConcurrentHashMap<Lang, RowSetStreamWriterFactory>();
    private static boolean initialized;

    public static RowSetStreamWriterFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void register(Lang lang, RowSetStreamWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (initialized) return;
        Class<RowSetStreamWriterRegistry> clazz = RowSetStreamWriterRegistry.class;
        synchronized (RowSetStreamWriterRegistry.class) {
            if (initialized) return;
            RowSetStreamWriterRegistry.register(ResultSetLang.RS_CSV, RowSetStreamWriterCSV.factory);
            RowSetStreamWriterRegistry.register(ResultSetLang.RS_TSV, RowSetStreamWriterTSV.factory);
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        RowSetStreamWriterRegistry.init();
        initialized = false;
    }
}

