/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.jena_sparql_api.io.binseach.GraphCacheStreaming;
import org.aksw.jena_sparql_api.io.binseach.GraphFindCache;
import org.aksw.jenax.arq.util.graph.GraphFindRaw;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;
import org.apache.jena.sparql.engine.iterator.QueryIterFilterExpr;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.main.StageGeneratorGeneric;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.SolverRX3;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;

public class StageGeneratorGraphFindRaw
extends StageGeneratorGeneric {
    protected QueryIterator execute(BasicPattern pattern, ReorderTransformation reorder, QueryIterator input, ExecutionContext execCxt) {
        Explain.explain((BasicPattern)pattern, (Context)execCxt.getContext());
        if (!input.hasNext()) {
            return input;
        }
        if (reorder != null && pattern.size() >= 2) {
            BasicPattern bgp2 = pattern;
            if (!input.isJoinIdentity()) {
                QueryIterPeek peek = QueryIterPeek.create((QueryIterator)input, (ExecutionContext)execCxt);
                input = peek;
                Binding b = peek.peek();
                bgp2 = Substitute.substitute((BasicPattern)pattern, (Binding)b);
            }
            ReorderProc reorderProc = reorder.reorderIndexes(bgp2);
            pattern = reorderProc.reorder(pattern);
        }
        Explain.explain((String)"Reorder/generic", (BasicPattern)pattern, (Context)execCxt.getContext());
        return StageGeneratorGraphFindRaw.execute(execCxt.getActiveGraph(), pattern, input, null, execCxt);
    }

    public static QueryIterator execute(Graph graph, BasicPattern pattern, QueryIterator input, Predicate<Triple> filter, ExecutionContext execCxt) {
        List triples = pattern.getList();
        QueryIterator chain = input;
        for (Triple triple : triples) {
            chain = StageGeneratorGraphFindRaw.rdfStarTriple(chain, graph, triple, execCxt);
        }
        return chain;
    }

    public static QueryIterator rdfStarTriple(QueryIterator chain, Graph graph, Triple tPattern, ExecutionContext execCxt) {
        return StageGeneratorGraphFindRaw.rdfStarTripleSub(chain, graph, tPattern, execCxt);
    }

    private static QueryIterator rdfStarTripleSub(QueryIterator input, final Graph graph, final Triple tPattern, final ExecutionContext execCxt) {
        return new QueryIterRepeatApply(input, execCxt){

            protected QueryIterator nextStage(Binding binding) {
                return StageGeneratorGraphFindRaw.rdfStarTripleSub(binding, graph, tPattern, execCxt);
            }
        };
    }

    public static QueryIterator rdfStarTripleSub(Binding input, Graph graph, Triple xPattern, ExecutionContext execCxt) {
        GraphFindRaw gfr = (GraphFindRaw)graph;
        Triple tPattern = Substitute.substitute((Triple)xPattern, (Binding)input);
        Node s = SolverLib.nodeTopLevel((Node)tPattern.getSubject());
        Node p = SolverLib.nodeTopLevel((Node)tPattern.getPredicate());
        Node o = SolverLib.nodeTopLevel((Node)tPattern.getObject());
        ExprList spoFilter = new ExprList();
        for (int i = 0; i < 3; ++i) {
            Node n = TripleUtils.getNode((Triple)tPattern, (int)i);
            if (!n.isConcrete()) continue;
            Var v = (Var)Vars.spo.get(i);
            spoFilter.add((Expr)new E_Equals((Expr)new ExprVar(v), ExprLib.nodeToExpr((Node)n)));
        }
        Triple lookup = Triple.create((Node)s, (Node)p, (Node)o);
        Function<Triple, QueryIterator> itFactory = lup -> {
            ExecutionContext isolatedExecCxt = new ExecutionContext(execCxt.getContext(), execCxt.getActiveGraph(), execCxt.getDataset(), execCxt.getExecutor());
            ExtendedIterator it = gfr.findRaw(lup).mapWith(TripleUtils::tripleToBinding);
            QueryIterator qIter = QueryIterPlainWrapper.create((Iterator)it);
            for (Expr condition : spoFilter) {
                qIter = new QueryIterFilterExpr(qIter, condition, isolatedExecCxt);
            }
            return qIter;
        };
        GraphFindCache cache = (GraphFindCache)execCxt.getContext().get(GraphFindCache.graphCache);
        QueryIterator spoIt = cache == null ? itFactory.apply(lookup) : GraphCacheStreaming.cache(cache, lookup, itFactory);
        Var dummyVar = Var.alloc((String)".binSearch_noMatchVar");
        Binding NO_MATCH = BindingFactory.binding((Var)dummyVar, (Node)NodeValue.TRUE.asNode());
        QueryIterConvert solvedIt = new QueryIterConvert(spoIt, b -> {
            Triple t = TripleUtils.bindingToTriple((Binding)b);
            Binding r = SolverRX3.matchTriple((Binding)input, (Triple)t, (Triple)tPattern);
            if (r == null) {
                r = NO_MATCH;
            }
            return r;
        }, execCxt);
        solvedIt = new QueryIterFilterExpr((QueryIterator)solvedIt, (Expr)new E_LogicalNot((Expr)new E_Bound((Expr)new ExprVar(dummyVar))), execCxt);
        return solvedIt;
    }
}

