/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.endpoint;

import io.reactivex.rxjava3.core.Single;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.io.endpoint.Destination;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFilter;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFromFileCreation;
import org.aksw.jena_sparql_api.io.endpoint.FileWritingProcess;
import org.aksw.jena_sparql_api.io.endpoint.FilterConfig;
import org.aksw.jena_sparql_api.io.endpoint.FilterEngine;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplier;
import org.aksw.jena_sparql_api.io.filter.sys.FilterExecutionFromSysFunction;

public class FilterExecutionJava
implements FilterConfig {
    protected Function<InputStream, InputStream> processor;
    protected Destination source;

    public FilterExecutionJava(Function<InputStream, InputStream> processor, Destination source) {
        this.processor = Objects.requireNonNull(processor);
        this.source = source;
    }

    @Override
    public Single<InputStreamSupplier> execStream() {
        return this.source.prepareStream().map(inSupp -> () -> {
            Single r = inSupp.execStream().map(this.processor::apply);
            return r;
        });
    }

    @Override
    public FilterConfig ifNeedsFileInput(Supplier<Path> pathRequester, BiConsumer<Path, FileWritingProcess> processCallback) {
        return this;
    }

    @Override
    public FilterConfig ifNeedsFileOutput(Supplier<Path> pathRequester, BiConsumer<Path, FileWritingProcess> processCallback) {
        return this;
    }

    @Override
    public FilterConfig pipeInto(FilterEngine nextFilter) {
        FilterConfig result = nextFilter.forInput(this);
        return result;
    }

    @Override
    public DestinationFromFileCreation outputToFile(Path path) {
        return new DestinationFromFileCreation(path, FilterExecutionFromSysFunction.forceDestinationToFile(this.execStream(), path));
    }

    @Override
    public Destination outputToStream() {
        return new DestinationFilter(this);
    }

    @Override
    public boolean requiresFileOutput() {
        return false;
    }

    public String toString() {
        return "FilterExecutionJava [processor=" + String.valueOf(this.processor) + ", source=" + String.valueOf(this.source) + "]";
    }
}

